/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.TemplateFileNotFoundException;
import at.mrdevelopment.esl.template.TemplateSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.xml.transform.stream.StreamSource;

public class FileTemplateSource
implements TemplateSource {
    private final String templateFilename;
    private final File workingDirectory;

    public FileTemplateSource(File templateFile) {
        this(templateFile.getParentFile(), templateFile.getName());
    }

    public FileTemplateSource(File workingDirectory, String templateFilename) {
        this.templateFilename = templateFilename;
        this.workingDirectory = workingDirectory;
    }

    public String getTemplateFilename() {
        return this.templateFilename;
    }

    @Override
    public StreamSource getSource() throws TemplateFileNotFoundException {
        try {
            return new StreamSource(new FileInputStream(new File(this.workingDirectory, this.templateFilename)));
        }
        catch (FileNotFoundException exc) {
            throw new TemplateFileNotFoundException(this.templateFilename);
        }
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }
}

