/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.DrawingElement;
import at.mrdevelopment.esl.template.FieldOutOfBoundsException;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.esl.template.RenderingResult;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.RenderingExceptionElement;
import at.mrdevelopment.toolkit.RenderingStringElement;
import at.mrdevelopment.toolkit.StringElement;
import at.mrdevelopment.toolkit.TableRenderingExceptionElement;
import at.mrdevelopment.toolkit.TableRenderingStringElement;
import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.BorderStyle;
import at.mrdevelopment.toolkit.image.HorizontalAlignment;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.image.RoundedCorner;
import at.mrdevelopment.toolkit.image.RoundedRectangle;
import at.mrdevelopment.toolkit.image.VerticalAlignment;
import at.mrdevelopment.toolkit.options.MissingRequiredOptionException;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.Alignment;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@TemplateElementType(type=TemplateNode.FIELD)
public class Field
extends Element {
    private RenderingElement renderingElement;
    private int posX;
    private int posY;
    private int width;
    private int height;
    private int maxHeight;
    private final int rotation;
    private final HorizontalAlignment horizontalAlignment;
    private final VerticalAlignment verticalAlignment;
    private final int border;
    private final Color borderColor;
    private final Color backgroundColor;
    private final boolean relative;
    private final int cornerRadius;
    private RoundedRectangle roundedRectangle = null;
    private final List<Field> nestedFields = new ArrayList<Field>();
    private Field parentField;
    private boolean successful = true;
    private BorderStyle borderStyle;
    private RenderingResult renderingResult = null;
    private BufferedImage fieldImage = null;
    private final List<DrawingElement> drawingElements = new ArrayList<DrawingElement>();

    public Field(Field parentField, Map<String, Option<?>> options) throws OptionException {
        super(options);
        this.parentField = parentField;
        if (!options.containsKey(Attribute.FIELD_HEIGHT.getKey()) && !options.containsKey(Attribute.MAX_HEIGHT.getKey())) {
            throw new MissingRequiredOptionException("Either height or max-height has to be specified for a field.", Attribute.HEIGHT);
        }
        this.posX = (Integer)options.get(Attribute.X.getKey()).get();
        this.posY = options.containsKey(Attribute.Y.getKey()) && options.get(Attribute.Y.getKey()).get() != null ? (Integer)options.get(Attribute.Y.getKey()).get() : -1;
        this.relative = this.posY == -1;
        this.border = (Integer)options.get(Attribute.BORDER.getKey()).get();
        this.borderStyle = (BorderStyle)options.get(Attribute.BORDER_STYLE.getKey()).get();
        this.cornerRadius = (Integer)options.get(Attribute.CORNER_RADIUS.getKey()).get();
        this.width = (Integer)options.get(Attribute.FIELD_WIDTH.getKey()).get();
        this.height = options.containsKey(Attribute.FIELD_HEIGHT.getKey()) && options.get(Attribute.FIELD_HEIGHT.getKey()).get() != null ? (Integer)options.get(Attribute.FIELD_HEIGHT.getKey()).get() : -1;
        int n = this.maxHeight = options.containsKey(Attribute.MAX_HEIGHT.getKey()) && options.get(Attribute.MAX_HEIGHT.getKey()).get() != null ? (Integer)options.get(Attribute.MAX_HEIGHT.getKey()).get() : -1;
        if (this.maxHeight != -1) {
            this.height = -1;
        }
        if (this.border > 0 && options.containsKey(Attribute.ROUNDED_CORNERS.getKey()) && this.cornerRadius > 0) {
            int flags = RoundedCorner.calculateFlags((Object[])((Object[])options.get(Attribute.ROUNDED_CORNERS.getKey()).get()));
            this.roundedRectangle = new RoundedRectangle((float)this.posX, (float)this.posY, (float)this.width, (float)this.getHeight(), (float)this.cornerRadius, flags);
        }
        this.rotation = (Integer)options.get(Attribute.ROTATION.getKey()).get();
        this.borderColor = (Color)options.get(Attribute.BORDER_COLOR.getKey()).get();
        this.backgroundColor = (Color)options.get(Attribute.BACKGROUND_COLOR.getKey()).get();
        this.verticalAlignment = (VerticalAlignment)options.get(Attribute.VERTICAL_ALIGNMENT.getKey()).get();
        HorizontalAlignment alignment = null;
        try {
            alignment = HorizontalAlignment.valueOf((String)((Alignment)options.get(Attribute.ALIGNMENT.getKey()).get()).name());
        }
        catch (IllegalArgumentException exc) {
            alignment = HorizontalAlignment.valueOf((String)options.get(Attribute.ALIGNMENT.getKey()).getDefaultValueAsString().toUpperCase());
        }
        this.horizontalAlignment = alignment;
    }

    public Collection<Attribute> getRequiredAttributes() {
        return Arrays.asList(Attribute.X, Attribute.FIELD_WIDTH);
    }

    public void setRenderingElement(RenderingElement renderingElement) {
        this.renderingElement = renderingElement;
    }

    public RenderingElement getRenderingElement() {
        return this.renderingElement;
    }

    public List<Field> getNestedFields() {
        return this.nestedFields;
    }

    public void addNestedField(Field nestedField) throws FieldOutOfBoundsException {
        if (!this.checkNestedFieldBounds(nestedField)) {
            throw new FieldOutOfBoundsException("Nested field does not fit into parent field.", nestedField, this);
        }
        this.nestedFields.add(nestedField);
    }

    private boolean checkNestedFieldBounds(Field nestedField) {
        int parentHeight = this.getHeight() == -1 ? this.getMaxHeight() : this.getHeight();
        int nestedHeight = nestedField.getHeight() == -1 ? nestedField.getMaxHeight() : nestedField.getHeight();
        return nestedField.getX() + nestedField.getWidth() <= this.getWidth() && (nestedHeight += nestedField.isRelativePositioned() ? 0 : nestedField.getY()) <= parentHeight;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public boolean isNestedField() {
        return this.parentField != null;
    }

    public int getX() {
        return this.getPosX();
    }

    public int getY() {
        return this.getPosY();
    }

    public boolean isRelativePositioned() {
        return this.relative;
    }

    public int getRotatedWidth() {
        return this.rotation == 90 || this.rotation == 270 ? this.getHeight() : this.getWidth();
    }

    public int getWidth() {
        return this.hasRoundedCorners() ? this.roundedRectangle.getInnerRectangle().width : this.width;
    }

    public int getHeight() {
        return this.height == -1 ? this.getMaxHeight() : (this.hasRoundedCorners() ? this.roundedRectangle.getInnerRectangle().height : this.height);
    }

    public int getRotatedHeight() {
        return this.rotation == 90 || this.rotation == 270 ? this.getWidth() : this.getHeight();
    }

    public int getMaxHeight() {
        return this.hasRoundedCorners() ? this.roundedRectangle.getInnerRectangle().height : this.maxHeight;
    }

    public boolean hasMaxHeight() {
        return this.maxHeight != -1;
    }

    public int getXOrigin() {
        return this.posX;
    }

    public int getYOrigin() {
        return this.posY;
    }

    public int getPosX() {
        return this.hasRoundedCorners() ? this.roundedRectangle.getInnerRectangle().x : this.posX;
    }

    public int getPosY() {
        return this.hasRoundedCorners() ? this.roundedRectangle.getInnerRectangle().y : this.posY;
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getBorder() {
        return this.border;
    }

    public boolean hasBorder() {
        return this.border > 0;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public HorizontalAlignment getHorizonalAlignment() {
        return this.horizontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setYPosition(int newPosY) {
        if (this.hasRoundedCorners()) {
            this.roundedRectangle.setYPos(newPosY);
        } else {
            this.posY = newPosY;
        }
    }

    public void setXPosition(int newPosX) {
        if (this.hasRoundedCorners()) {
            this.roundedRectangle.setXPos(newPosX);
        } else {
            this.posX = newPosX;
        }
    }

    public void setUsedHeight(int usedHeight) {
        if (this.height < 0) {
            if (this.hasRoundedCorners()) {
                this.roundedRectangle.setHeightBasedOnInnerRectangle(usedHeight);
            } else {
                this.height = usedHeight;
            }
        }
    }

    public boolean hasRoundedCorners() {
        return this.roundedRectangle != null;
    }

    public RoundedRectangle getRoundedRectangle() {
        return this.roundedRectangle;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + String.format(": x=%d, y=%d, width=%d, height=%d", this.getPosX(), this.getPosY(), this.getWidth(), this.getHeight());
    }

    public boolean hasNestedFields() {
        return this.getNestedFields().size() > 0;
    }

    public void render(boolean verboseEnabled, ExecutionStatus executionStatus, int fieldId) {
        int renderWidth = this.getWidth();
        int renderHeight = this.getHeight();
        if (this.renderingElement != null) {
            this.renderingResult = this.renderingElement.render(renderWidth, renderHeight, verboseEnabled);
            if (verboseEnabled && executionStatus != null) {
                for (ExecutionStatusElement element : this.renderingResult.getStatus().getElements()) {
                    TableRenderingExceptionElement tableElement;
                    if (element instanceof TableRenderingExceptionElement) {
                        tableElement = (TableRenderingExceptionElement)element;
                        tableElement.setFieldId(fieldId + 1);
                        executionStatus.addElement((ExecutionStatusElement)tableElement);
                        continue;
                    }
                    if (element instanceof TableRenderingStringElement) {
                        tableElement = (TableRenderingStringElement)element;
                        tableElement.setFieldId(fieldId + 1);
                        executionStatus.addElement((ExecutionStatusElement)tableElement);
                        continue;
                    }
                    if (element.getElement() instanceof Exception) {
                        executionStatus.addElement((ExecutionStatusElement)new RenderingExceptionElement((Exception)element.getElement(), fieldId));
                        continue;
                    }
                    if (element.getElement() instanceof String) {
                        executionStatus.addElement((ExecutionStatusElement)new RenderingStringElement((StringElement)element, fieldId));
                        continue;
                    }
                    executionStatus.addElement(element);
                }
            }
        }
    }

    public boolean isRendered() {
        return this.renderingResult != null;
    }

    public RenderingResult getRenderingResult() {
        return this.renderingResult;
    }

    public void setFieldImage(BufferedImage fieldImage) {
        this.fieldImage = fieldImage;
    }

    public BufferedImage getFieldImage() {
        return this.fieldImage;
    }

    public BufferedImage createFieldImage(boolean verboseEnabled, ExecutionStatus executionStatus) {
        int renderWidth = this.getWidth();
        int renderHeight = this.getHeight();
        ArrayList<RenderingResult> renderingResults = new ArrayList<RenderingResult>();
        BufferedImage tempImage = ImageUtils.createImage((int)(this.hasRoundedCorners() ? (int)this.getRoundedRectangle().getWidth() : this.getWidth()), (int)(this.hasRoundedCorners() ? (int)this.getRoundedRectangle().getHeight() : renderHeight), (int)2, (Color)this.getBackgroundColor());
        Rectangle bounds = new Rectangle(tempImage.getWidth(), tempImage.getHeight());
        for (DrawingElement drawingElement : this.drawingElements) {
            if (bounds.contains(drawingElement.getBounds())) {
                RenderingElement renderingElement = drawingElement.getRenderingElement();
                RenderingResult renderingResult = renderingElement.render(renderWidth, renderHeight, verboseEnabled);
                renderingResults.add(renderingResult);
                this.setSuccessful(!renderingResult.isSuccessful() ? renderingResult.isSuccessful() : this.successful);
                if (verboseEnabled && executionStatus != null) {
                    for (ExecutionStatusElement element : renderingResult.getStatus().getElements()) {
                        executionStatus.addElement((ExecutionStatusElement)new RenderingExceptionElement((Exception)element.getElement()));
                    }
                }
                try {
                    ImageUtils.overlay((BufferedImage)tempImage, (BufferedImage)renderingResult.getImage(), (int)0, (int)0, (int)renderingResult.getImage().getWidth(), (int)renderingResult.getImage().getHeight(), (int)0, (HorizontalAlignment)HorizontalAlignment.LEFT, (VerticalAlignment)VerticalAlignment.TOP);
                }
                catch (IllegalArgumentException exc) {
                    if (verboseEnabled && executionStatus != null) {
                        executionStatus.addElement((ExecutionStatusElement)new RenderingExceptionElement((Exception)((Object)new ImageRenderingException(String.format("Drawing element %s (x=%d, y=%d, widht=%d, height=%d) does not fit in field.", drawingElement.getClass().getSimpleName(), drawingElement.getBounds().x, drawingElement.getBounds().y, drawingElement.getBounds().width, drawingElement.getBounds().height), new Object[0]))));
                    }
                    this.setSuccessful(false);
                }
                continue;
            }
            if (verboseEnabled && executionStatus != null) {
                executionStatus.addElement((ExecutionStatusElement)new RenderingExceptionElement((Exception)((Object)new ImageRenderingException(String.format("Drawing element %s (x=%d, y=%d, widht=%d, height=%d) does not fit in field.", drawingElement.getClass().getSimpleName(), drawingElement.getBounds().x, drawingElement.getBounds().y, drawingElement.getBounds().width, drawingElement.getBounds().height), new Object[0]))));
            }
            this.setSuccessful(false);
        }
        if (this.hasMaxHeight()) {
            int currentHeight = this.getHeight();
            for (RenderingResult result : renderingResults) {
                int resultHeight = result.getBounds().y + result.getBounds().height;
                if (resultHeight <= currentHeight) continue;
                currentHeight = resultHeight;
            }
            if (currentHeight > this.getMaxHeight()) {
                currentHeight = this.getMaxHeight();
            }
            if (this.hasRoundedCorners()) {
                this.roundedRectangle.setHeightBasedOnInnerRectangle(currentHeight);
            } else {
                this.height = currentHeight;
            }
            return ImageUtils.clip((BufferedImage)tempImage, (Rectangle)new Rectangle(0, 0, this.hasRoundedCorners() ? (int)this.getRoundedRectangle().getWidth() : this.getWidth(), this.hasRoundedCorners() ? (int)this.getRoundedRectangle().getHeight() : this.getHeight()));
        }
        return tempImage;
    }

    public void addDrawingElement(DrawingElement drawingElement) {
        this.drawingElements.add(drawingElement);
    }

    public List<DrawingElement> getDrawingElements() {
        return this.drawingElements;
    }

    public void clipRenderingResultToUsedHeight() {
        this.renderingResult.setImage(ImageUtils.clip((BufferedImage)this.renderingResult.getImage(), (Rectangle)new Rectangle(this.renderingResult.getBounds().x, this.renderingResult.getBounds().y, this.getWidth(), this.getHeight())));
    }
}

