/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.esl.template.DrawingElement;
import at.mrdevelopment.esl.template.Field;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.ImageTemplate;
import at.mrdevelopment.esl.template.RenderingElement;
import at.mrdevelopment.esl.template.RenderingResult;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.RenderingExceptionElement;
import at.mrdevelopment.toolkit.StringElement;
import at.mrdevelopment.toolkit.image.HorizontalAlignment;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.image.RoundedRectangle;
import at.mrdevelopment.toolkit.image.VerticalAlignment;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class ESLImage {
    static ESLLogger logger = ESLLogger.getLogger(ESLImage.class);
    private final BufferedImage image;
    private final ExecutionStatus executionStatus;
    private final boolean verbose;
    private boolean successful;
    private final Rectangle clippingRegion;

    public ESLImage(ImageTemplate imageTemplate) throws ImageRenderingException {
        this(imageTemplate, 12, false);
    }

    public ESLImage(ImageTemplate imageTemplate, boolean verboseMode) throws ImageRenderingException {
        this(imageTemplate, 12, verboseMode);
    }

    protected ESLImage(ImageTemplate imageTemplate, int bufferedImageType, boolean verboseMode) throws ImageRenderingException {
        BufferedImage tempImage;
        block23: {
            this.successful = true;
            this.verbose = verboseMode;
            this.clippingRegion = imageTemplate.getClippingRegion();
            this.executionStatus = new ExecutionStatus();
            tempImage = new BufferedImage(imageTemplate.getWidth(), imageTemplate.getHeight(), 2);
            try {
                this.drawBackgroundImage(tempImage, imageTemplate.getBackgroundImage(), imageTemplate.getBackgroundColor());
                for (DrawingElement drawingElement : imageTemplate.getDrawingElements()) {
                    if (logger.isInfoEnabled()) {
                        logger.info("DrawingElement %s (bounds: %s)", new Object[]{drawingElement.getRenderingElement().getClass(), drawingElement.getBounds().toString()});
                    }
                    RenderingElement renderingElement = drawingElement.getRenderingElement();
                    RenderingResult renderingResult = renderingElement.render(imageTemplate.getWidth(), imageTemplate.getHeight(), this.verbose);
                    this.setSuccessful(renderingResult.isSuccessful());
                    if (this.isVerboseEnabled()) {
                        for (ExecutionStatusElement element : renderingResult.getStatus().getElements()) {
                            this.executionStatus.addElement((ExecutionStatusElement)new RenderingExceptionElement((Exception)element.getElement()));
                        }
                    }
                    try {
                        ImageUtils.overlay((BufferedImage)tempImage, (BufferedImage)renderingResult.getImage(), (int)0, (int)0, (int)renderingResult.getImage().getWidth(), (int)renderingResult.getImage().getHeight(), (int)0, (HorizontalAlignment)HorizontalAlignment.LEFT, (VerticalAlignment)VerticalAlignment.TOP);
                    }
                    catch (IllegalArgumentException exc) {
                        if (this.isVerboseEnabled()) {
                            logger.logExceptionIfDebugEnabled((Throwable)exc);
                            this.executionStatus.addElement((ExecutionStatusElement)new RenderingExceptionElement((Exception)((Object)new ImageRenderingException(String.format("Drawing element %s (x=%d, y=%d, widht=%d, height=%d) does not fit on image.", drawingElement.getClass().getSimpleName(), drawingElement.getBounds().x, drawingElement.getBounds().y, drawingElement.getBounds().width, drawingElement.getBounds().height), new Object[0]))));
                        }
                        this.setSuccessful(false);
                    }
                }
                int yPos = 0;
                for (Field field : imageTemplate.getFields()) {
                    yPos = this.renderField(field, yPos, imageTemplate);
                    if (field.getRotation() != 0) {
                        BufferedImage rotatedFieldImage = ImageUtils.rotateImage((BufferedImage)field.getFieldImage(), (double)field.getRotation(), (Color)imageTemplate.getBackgroundColor(), (Color)(field.hasBorder() ? field.getBorderColor() : null), (Stroke)(field.hasBorder() ? field.getBorderStyle().getStroke(field.getBorder()) : null), (RoundedRectangle)(field.hasRoundedCorners() ? field.getRoundedRectangle() : null), (int)0, (int)0);
                        try {
                            ImageUtils.overlayAt((BufferedImage)tempImage, (BufferedImage)rotatedFieldImage, (int)field.getXOrigin(), (int)field.getYOrigin());
                        }
                        catch (IllegalArgumentException exc) {
                            this.addStatusMessage(String.format("Rotated field does not fit into image", new Object[0]));
                            this.handleIllegalArgument(exc, this.executionStatus, imageTemplate, rotatedFieldImage, field, imageTemplate.getFields().indexOf((Object)field));
                        }
                        continue;
                    }
                    try {
                        ImageUtils.overlayAt((BufferedImage)tempImage, (BufferedImage)field.getFieldImage(), (int)field.getXOrigin(), (int)field.getYOrigin());
                    }
                    catch (IllegalArgumentException exc) {
                        this.handleIllegalArgument(exc, this.executionStatus, imageTemplate, field.getFieldImage(), field, imageTemplate.getFields().indexOf((Object)field));
                    }
                    if (!field.hasBorder()) continue;
                    this.drawFieldBorder(tempImage, field);
                }
                if (this.clippingRegion != null) {
                    tempImage = ImageUtils.clip((BufferedImage)tempImage, (Rectangle)this.clippingRegion);
                }
                if (imageTemplate.hasRotation()) {
                    tempImage = ImageUtils.rotate((BufferedImage)tempImage, (int)imageTemplate.getRotation());
                }
            }
            catch (IOException exc) {
                if (!this.isVerboseEnabled()) break block23;
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                this.executionStatus.addElement((ExecutionStatusElement)new ExceptionElement((Exception)((Object)new ImageRenderingException(exc))));
            }
        }
        if (imageTemplate.isInverted()) {
            tempImage = ImageUtils.invert((BufferedImage)tempImage);
        }
        if (imageTemplate.isDitheringEnabled()) {
            tempImage = ImageUtils.ditherImage((BufferedImage)tempImage);
        }
        if (bufferedImageType == tempImage.getType()) {
            this.image = tempImage;
        } else if (bufferedImageType == 12 && !imageTemplate.isUseColors()) {
            this.image = new BufferedImage(tempImage.getWidth(), tempImage.getHeight(), bufferedImageType);
            Graphics2D graphics = this.image.createGraphics();
            graphics.drawImage((Image)tempImage, 0, 0, null);
            graphics.dispose();
        } else {
            this.image = tempImage;
        }
    }

    private int renderField(Field field, int yPos, ImageTemplate imageTemplate) {
        if (logger.isInfoEnabled()) {
            logger.info("Field %s (width=%d, height=%s)", new Object[]{field.getRenderingElement() != null ? field.getRenderingElement().getClass() : "", field.getWidth(), field.getHeight()});
        }
        if (field.isRelativePositioned()) {
            field.setYPosition(yPos);
        }
        field.render(this.isVerboseEnabled(), this.executionStatus, imageTemplate.getFields().indexOf((Object)field));
        if (field.hasNestedFields()) {
            int nestedYPos = 0;
            for (Field nestedField : field.getNestedFields()) {
                nestedYPos += this.renderField(nestedField, nestedYPos, imageTemplate);
            }
        }
        if (field.hasMaxHeight()) {
            if (field.isRendered()) {
                Rectangle usedBounds = new Rectangle(0, 0, field.getWidth(), field.getRenderingResult().getBounds().height);
                if (field.hasNestedFields()) {
                    for (Field nestedField : field.getNestedFields()) {
                        usedBounds.width = Math.max(nestedField.getX() + nestedField.getWidth(), usedBounds.width);
                        int nestedHeight = nestedField.getY() + nestedField.getHeight();
                        if (nestedField.isRelativePositioned()) {
                            usedBounds.height += nestedHeight;
                            continue;
                        }
                        usedBounds.height = Math.max(usedBounds.height, nestedHeight);
                    }
                }
                int usedHeight = usedBounds.height > field.getMaxHeight() ? field.getMaxHeight() : usedBounds.height;
                field.setUsedHeight(Math.max(1, usedHeight));
                field.clipRenderingResultToUsedHeight();
            } else {
                field.setUsedHeight(field.getMaxHeight());
            }
        }
        BufferedImage fieldImage = field.createFieldImage(this.isVerboseEnabled(), this.executionStatus);
        LinkedList<BufferedImage> relativeImages = new LinkedList<BufferedImage>();
        if (field.isRendered()) {
            relativeImages.add(field.getRenderingResult().getImage());
        }
        if (field.hasNestedFields()) {
            for (Field nestedField : field.getNestedFields()) {
                if (!nestedField.isRelativePositioned()) continue;
                if (nestedField.getRotation() != 0) {
                    BufferedImage rotatedFieldImage = ImageUtils.rotateImage((BufferedImage)nestedField.getFieldImage(), (double)nestedField.getRotation(), (Color)field.getBackgroundColor(), (Color)(nestedField.hasBorder() ? nestedField.getBorderColor() : null), (Stroke)(nestedField.hasBorder() ? nestedField.getBorderStyle().getStroke(nestedField.getBorder()) : null), (RoundedRectangle)(nestedField.hasRoundedCorners() ? nestedField.getRoundedRectangle() : null), (int)0, (int)0);
                    relativeImages.add(rotatedFieldImage);
                    continue;
                }
                relativeImages.add(nestedField.getFieldImage());
            }
        }
        if (relativeImages.size() > 0) {
            LinkedList combineAndAlignImages = ImageUtils.combineAndAlignImages(relativeImages, (BufferedImage)fieldImage, (VerticalAlignment)field.getVerticalAlignment(), (HorizontalAlignment)field.getHorizonalAlignment(), (int)field.getRotation());
            int index = 0;
            for (int i = 0; i < field.getNestedFields().size(); ++i) {
                if (!field.getNestedFields().get(i).isRelativePositioned()) continue;
                int currentIndex = relativeImages.size() > field.getNestedFields().size() ? index + 1 : index;
                field.getNestedFields().get(i).setYPosition(((Rectangle)combineAndAlignImages.get((int)currentIndex)).y);
                field.getNestedFields().get(i).setXPosition(((Rectangle)combineAndAlignImages.get((int)currentIndex)).x);
                if (field.getNestedFields().get(i).getRotation() == 0) {
                    this.drawBorder(field.getNestedFields().get(i), fieldImage, (Rectangle)combineAndAlignImages.get(currentIndex));
                }
                ++index;
            }
        }
        if (field.hasNestedFields()) {
            for (Field nestedField : field.getNestedFields()) {
                if (nestedField.isRelativePositioned()) continue;
                if (nestedField.getRotation() != 0) {
                    BufferedImage rotatedFieldImage = ImageUtils.rotateImage((BufferedImage)nestedField.getFieldImage(), (double)nestedField.getRotation(), (Color)field.getBackgroundColor(), (Color)(nestedField.hasBorder() ? nestedField.getBorderColor() : null), (Stroke)(nestedField.hasBorder() ? nestedField.getBorderStyle().getStroke(nestedField.getBorder()) : null), (RoundedRectangle)(nestedField.hasRoundedCorners() ? nestedField.getRoundedRectangle() : null), (int)0, (int)0);
                    if (nestedField.hasMaxHeight()) {
                        nestedField.setUsedHeight(rotatedFieldImage.getHeight());
                    }
                    try {
                        ImageUtils.overlayAt((BufferedImage)fieldImage, (BufferedImage)rotatedFieldImage, (int)nestedField.getXOrigin(), (int)nestedField.getYOrigin());
                    }
                    catch (IllegalArgumentException exc) {
                        this.addStatusMessage("Could not fit rotated nested field on parent field (" + field.toString() + ")");
                        this.handleIllegalArgument(exc, this.executionStatus, imageTemplate, rotatedFieldImage, nestedField, field.getNestedFields().indexOf((Object)nestedField));
                    }
                    continue;
                }
                try {
                    if (nestedField.hasMaxHeight()) {
                        nestedField.setUsedHeight(nestedField.getFieldImage().getHeight());
                    }
                    ImageUtils.overlayAt((BufferedImage)fieldImage, (BufferedImage)nestedField.getFieldImage(), (int)nestedField.getXOrigin(), (int)nestedField.getYOrigin());
                }
                catch (IllegalArgumentException exc) {
                    this.addStatusMessage("Could not fit nested field on parent field (" + field.toString() + ")");
                    this.handleIllegalArgument(exc, this.executionStatus, imageTemplate, nestedField.getFieldImage(), nestedField, field.getNestedFields().indexOf((Object)nestedField));
                }
                if (!nestedField.hasBorder()) continue;
                this.drawNestedFieldBorder(fieldImage, nestedField, nestedField.getBorder());
            }
        }
        if (!field.isSuccessful()) {
            this.setSuccessful(false);
        }
        field.setFieldImage(fieldImage);
        return field.hasRoundedCorners() ? (int)(field.getRoundedRectangle().getY() + field.getRoundedRectangle().getHeight()) : field.getY() + field.getHeight();
    }

    private void addStatusMessage(String message) {
        if (this.executionStatus != null && this.isVerboseEnabled()) {
            this.executionStatus.addElement((ExecutionStatusElement)new StringElement(message, ExecutionStatusElement.ErrorLevel.ERROR));
        }
    }

    private void drawFieldBorder(BufferedImage tempImage, Field field) {
        if (field.hasRoundedCorners()) {
            ImageUtils.drawBorder((BufferedImage)tempImage, (int)field.getXOrigin(), (int)field.getYOrigin(), (RoundedRectangle)field.getRoundedRectangle(), (Color)field.getBorderColor(), (Stroke)field.getBorderStyle().getStroke(field.getBorder()));
        } else {
            ImageUtils.drawBorder((BufferedImage)tempImage, (int)field.getPosX(), (int)field.getY(), (int)field.getWidth(), (int)field.getHeight(), (Color)field.getBorderColor(), (Stroke)field.getBorderStyle().getStroke(field.getBorder()));
        }
    }

    private void drawNestedFieldBorder(BufferedImage fieldImage, Field field, int border) {
        if (field.hasRoundedCorners()) {
            ImageUtils.drawBorder((BufferedImage)fieldImage, (RoundedRectangle)field.getRoundedRectangle(), (Color)field.getBorderColor(), (Stroke)field.getBorderStyle().getStroke(border));
        } else {
            ImageUtils.drawBorder((BufferedImage)fieldImage, (int)field.getPosX(), (int)field.getY(), (int)field.getWidth(), (int)field.getHeight(), (Color)field.getBorderColor(), (Stroke)field.getBorderStyle().getStroke(border));
        }
    }

    private void drawBorder(Field field, BufferedImage fieldImage, Rectangle rectangle) {
        if (field.hasBorder()) {
            if (field.hasRoundedCorners()) {
                RoundedRectangle roundedRectangle = new RoundedRectangle((float)rectangle.x, (float)rectangle.y, (float)rectangle.width, (float)rectangle.height, field.getRoundedRectangle().getCornerRadius(), field.getRoundedRectangle().getCornerFlags(), field.getRoundedRectangle().getSegmentCount());
                ImageUtils.drawBorder((BufferedImage)fieldImage, (RoundedRectangle)roundedRectangle, (Color)field.getBorderColor(), (Stroke)field.getBorderStyle().getStroke(field.getBorder()));
            } else {
                ImageUtils.drawBorder((BufferedImage)fieldImage, (int)rectangle.x, (int)rectangle.y, (int)rectangle.width, (int)rectangle.height, (Color)field.getBorderColor(), (Stroke)field.getBorderStyle().getStroke(field.getBorder()));
            }
        }
    }

    private void drawBackgroundImage(BufferedImage tempImage, File backgroundImageFile, Color backgroundColor) throws IOException {
        if (backgroundColor.getAlpha() == 0) {
            ImageUtils.fill((BufferedImage)tempImage, (Color)Color.white);
        } else {
            ImageUtils.fill((BufferedImage)tempImage, (Color)backgroundColor);
        }
        if (backgroundImageFile != null) {
            BufferedImage backgroundImage = ImageIO.read(backgroundImageFile);
            ImageUtils.overlayTopLeft((BufferedImage)tempImage, (BufferedImage)backgroundImage);
        }
    }

    private void handleIllegalArgument(IllegalArgumentException exc, ExecutionStatus status, ImageTemplate imageTemplate, BufferedImage image, Field field, int fieldId) {
        if (this.isVerboseEnabled()) {
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            if (status != null) {
                status.addElement((ExecutionStatusElement)new RenderingExceptionElement((Exception)((Object)new ImageRenderingException("Field does not fit into background. " + field.toString() + String.format(". Image: width=%d, height=%d", image.getWidth(), image.getHeight()), new Object[0])), fieldId));
            }
        }
        this.setSuccessful(false);
    }

    public void export(String fileName) throws IOException {
        ImageIO.write((RenderedImage)this.image, "png", new File(fileName));
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public ExecutionStatus getStatus() {
        return this.executionStatus;
    }

    public boolean isVerboseEnabled() {
        return logger.isDebugEnabled() || this.verbose;
    }

    private void setSuccessful(boolean successful) {
        this.successful = !successful ? false : this.successful;
    }

    public boolean isSuccessful() {
        return this.successful;
    }
}

