/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.toolkit.image.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class DisplaySegments {
    private final boolean[] segments;

    public static DisplaySegments fromImage(BufferedImage segmentImage) {
        BufferedImage image = ImageUtils.toBlackWhite((BufferedImage)segmentImage);
        WritableRaster raster = image.getRaster();
        boolean[] segments = new boolean[image.getWidth()];
        for (int index = 0; index < segments.length; ++index) {
            segments[index] = raster.getSample(segments.length - index - 1, 0, 0) == 0;
        }
        return new DisplaySegments(segments);
    }

    private DisplaySegments(boolean[] segments) {
        this.segments = segments;
    }

    public boolean[] getSegments() {
        return this.segments;
    }

    public Image toImage() {
        BufferedImage image = new BufferedImage(this.segments.length, 1, 12);
        WritableRaster raster = image.getRaster();
        for (int index = 0; index < this.segments.length; ++index) {
            int value = this.segments[index] ? 0 : 255;
            raster.setSample(index, 0, 0, value);
            raster.setSample(index, 0, 1, value);
            raster.setSample(index, 0, 2, value);
        }
        return image;
    }
}

