/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.template;

import at.mrdevelopment.Pair;
import at.mrdevelopment.esl.template.ESLImage;
import at.mrdevelopment.esl.template.Field;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.ImageTemplate;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.RenderingExceptionElement;
import at.mrdevelopment.toolkit.image.ImageUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class DebugESLImage
extends ESLImage {
    private static final Color DEFAULT_DEBUG_BORDER_COLOR_ERROR = Color.RED;
    private static final Color DEFAULT_DEBUG_BORDER_COLOR_OK = Color.GREEN;

    public DebugESLImage(ImageTemplate imageTemplate, boolean verbose) throws ImageRenderingException {
        super(imageTemplate, 2, verbose);
        this.checkOverlapping(imageTemplate);
        this.checkOversized(imageTemplate);
    }

    public DebugESLImage(ImageTemplate imageTemplate) throws ImageRenderingException {
        this(imageTemplate, true);
    }

    private void checkOversized(ImageTemplate imageTemplate) {
        for (Field field : imageTemplate.getFields()) {
            if (field.getPosX() + field.getWidth() <= imageTemplate.getWidth() && field.getPosY() + field.getHeight() <= imageTemplate.getHeight()) continue;
            this.drawBorder(field, DEFAULT_DEBUG_BORDER_COLOR_ERROR, imageTemplate);
        }
    }

    private void checkOverlapping(ImageTemplate imageTemplate) {
        ArrayList<Pair<Field, Field>> intersections = new ArrayList<Pair<Field, Field>>();
        for (Field field : imageTemplate.getFields()) {
            if (field.hasNestedFields()) {
                this.checkNestedFieldsOverlapping(imageTemplate, field, 0, 0);
            }
            boolean intersects = false;
            for (Field fieldToCheckWith : imageTemplate.getFields()) {
                if (((Object)((Object)field)).equals((Object)fieldToCheckWith) || !this.intersect(field, fieldToCheckWith)) continue;
                intersects = true;
                if (this.alreadyDetected(field, fieldToCheckWith, intersections)) continue;
                intersections.add((Pair<Field, Field>)new Pair((Object)field, (Object)fieldToCheckWith));
                this.getStatus().addElement((ExecutionStatusElement)new RenderingExceptionElement((Exception)((Object)new ImageRenderingException("Field %d overlaps with field %d", imageTemplate.getFields().indexOf((Object)field) + 1, imageTemplate.getFields().indexOf((Object)fieldToCheckWith) + 1)), imageTemplate.getFields().indexOf((Object)field) + 1));
                this.drawBorder(field, DEFAULT_DEBUG_BORDER_COLOR_ERROR, imageTemplate);
                this.drawBorder(fieldToCheckWith, DEFAULT_DEBUG_BORDER_COLOR_ERROR, imageTemplate);
            }
            if (intersects) continue;
            this.drawBorder(field, DEFAULT_DEBUG_BORDER_COLOR_OK, imageTemplate);
        }
    }

    private void checkNestedFieldsOverlapping(ImageTemplate imageTemplate, Field field, int xOffset, int yOffset) {
        ArrayList<Pair<Field, Field>> intersections = new ArrayList<Pair<Field, Field>>();
        Rectangle fieldBounds = this.getFieldBounds(field);
        for (Field nestedField : field.getNestedFields()) {
            if (nestedField.hasNestedFields()) {
                this.checkNestedFieldsOverlapping(imageTemplate, nestedField, xOffset + fieldBounds.x, yOffset + fieldBounds.y);
            }
            boolean intersects = false;
            for (Field fieldToCheckWith : field.getNestedFields()) {
                if (((Object)((Object)nestedField)).equals((Object)fieldToCheckWith) || !this.intersect(nestedField, fieldToCheckWith)) continue;
                intersects = true;
                if (this.alreadyDetected(nestedField, fieldToCheckWith, intersections)) continue;
                intersections.add((Pair<Field, Field>)new Pair((Object)field, (Object)fieldToCheckWith));
                this.getStatus().addElement((ExecutionStatusElement)new RenderingExceptionElement((Exception)((Object)new ImageRenderingException("The nested field %d overlaps with field %d in parent field %d", field.getNestedFields().indexOf((Object)nestedField) + 1, field.getNestedFields().indexOf((Object)fieldToCheckWith) + 1, imageTemplate.getFields().indexOf((Object)field) + 1, imageTemplate.getFields().indexOf((Object)fieldToCheckWith) + 1)), imageTemplate.getFields().indexOf((Object)field) + 1));
                this.drawNestedBorder(nestedField, field, DEFAULT_DEBUG_BORDER_COLOR_ERROR, imageTemplate, xOffset, yOffset);
                this.drawNestedBorder(fieldToCheckWith, field, DEFAULT_DEBUG_BORDER_COLOR_ERROR, imageTemplate, xOffset, yOffset);
            }
            if (intersects) continue;
            this.drawNestedBorder(nestedField, field, DEFAULT_DEBUG_BORDER_COLOR_OK, imageTemplate, xOffset, yOffset);
        }
    }

    private boolean alreadyDetected(Field field1, Field field2, List<Pair<Field, Field>> intersections) {
        for (Pair<Field, Field> intersection : intersections) {
            if (!((Object)((Object)field1)).equals(intersection.getFirst()) && !((Object)((Object)field1)).equals(intersection.getSecond()) || !((Object)((Object)field2)).equals(intersection.getFirst()) && !((Object)((Object)field2)).equals(intersection.getSecond()) || ((Object)((Object)field1)).equals((Object)field2)) continue;
            return true;
        }
        return false;
    }

    protected void drawBorder(Field field, Color color, ImageTemplate imageTemplate) {
        Rectangle bounds = this.getFieldBounds(field);
        if (imageTemplate.hasRotation()) {
            bounds = ImageUtils.rotate((int)imageTemplate.getRotation(), (Rectangle)bounds, (int)imageTemplate.getHeight(), (int)imageTemplate.getWidth());
        }
        ImageUtils.drawBorder((BufferedImage)this.getImage(), (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (Color)color);
    }

    protected void drawNestedBorder(Field nestedField, Field parentField, Color color, ImageTemplate imageTemplate, int xOffset, int yOffset) {
        Rectangle nestedBounds = this.getFieldBounds(nestedField);
        Rectangle parentBounds = this.getFieldBounds(parentField);
        nestedBounds.x += parentBounds.x + xOffset;
        nestedBounds.y += parentBounds.y + yOffset;
        if (imageTemplate.hasRotation()) {
            nestedBounds = ImageUtils.rotate((int)imageTemplate.getRotation(), (Rectangle)nestedBounds, (int)imageTemplate.getHeight(), (int)imageTemplate.getWidth());
        }
        ImageUtils.drawBorder((BufferedImage)this.getImage(), (int)nestedBounds.x, (int)nestedBounds.y, (int)nestedBounds.width, (int)nestedBounds.height, (Color)color);
    }

    public boolean intersect(Field field1, Field field2) {
        Rectangle field1Bounds = this.getFieldBounds(field1);
        Rectangle field2Bounds = this.getFieldBounds(field2);
        return field1Bounds.intersects(field2Bounds);
    }

    private Rectangle getFieldBounds(Field field) {
        if (field.getRotation() != 0) {
            BufferedImage rotatedFieldImage = ImageUtils.rotateImage((BufferedImage)field.getFieldImage(), (double)field.getRotation(), (Color)field.getBackgroundColor(), null, null, null, (int)0, (int)0);
            return new Rectangle(field.getXOrigin(), field.getYOrigin(), rotatedFieldImage.getWidth(), rotatedFieldImage.getHeight());
        }
        return new Rectangle(field.getX(), field.getY(), field.getFieldImage().getWidth(), field.getFieldImage().getHeight());
    }
}

