/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.esl.core.DefaultLabelTagsLookup;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelTagsLookup;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.tasks.DefaultEnvironmentSource;
import at.mrdevelopment.esl.tasks.DefaultRecordSourceLogger;
import at.mrdevelopment.esl.tasks.EnvironmentSource;
import at.mrdevelopment.esl.tasks.ImageRenderingTask;
import at.mrdevelopment.esl.tasks.ImageTask;
import at.mrdevelopment.esl.tasks.RecordSourceLogger;
import at.mrdevelopment.esl.tasks.ResetImageTask;
import at.mrdevelopment.esl.tasks.TemplateTask;
import at.mrdevelopment.esl.tasks.TemplateValuesTask;
import at.mrdevelopment.esl.tasks.TemplateXMLTask;
import at.mrdevelopment.esl.template.DebugESLImage;
import at.mrdevelopment.esl.template.DefaultTemplateUtils;
import at.mrdevelopment.esl.template.ESLImage;
import at.mrdevelopment.esl.template.ImageRenderingException;
import at.mrdevelopment.esl.template.ImageTemplate;
import at.mrdevelopment.esl.template.ImageXMLSerializer;
import at.mrdevelopment.esl.template.TemplateUtilsFactory;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.specific.Code128Code;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UpdateImageFactory {
    static ESLLogger logger = ESLLogger.getLogger(UpdateImageFactory.class);
    protected static final int RESET_BARCODE_HEIGHT = 80;
    protected static final int RESET_FONT_SIZE = 9;
    private final XMLToolkit xmlToolkit = new XMLToolkit();
    private final ImageXMLSerializer templateXMLSerializer = new ImageXMLSerializer();
    private final TemplateUtilsFactory templateUtilsFactory = new TemplateUtilsFactory();
    private final RecordSourceLogger recordSourceLogger;
    private final EnvironmentSource environmentSource;
    private final LabelTagsLookup labelTagsLookup;

    public UpdateImageFactory() throws InitializationException {
        this(new DefaultRecordSourceLogger(), new DefaultEnvironmentSource(), new DefaultLabelTagsLookup());
    }

    public UpdateImageFactory(RecordSourceLogger recordSourceLogger, EnvironmentSource environmentSource, LabelTagsLookup labelTagsLookup) throws InitializationException {
        this.templateUtilsFactory.registerTemplateUtils(new DefaultTemplateUtils());
        this.recordSourceLogger = recordSourceLogger;
        this.environmentSource = environmentSource;
        this.labelTagsLookup = labelTagsLookup;
    }

    public BufferedImage createImageFromTask(ImageRenderingTask task) throws ImageRenderingException, SerializeException, BarcodeException, OptionException {
        BufferedImage image = null;
        if (task instanceof TemplateTask) {
            TemplateTask templateTask = (TemplateTask)task;
            ESLImage eslImage = this.createFromTemplateTask(templateTask, null, false, logger.isDebugEnabled());
            image = eslImage.getImage();
        } else if (task instanceof ImageTask) {
            ImageTask imageTask = (ImageTask)task;
            image = this.createFromImageTask(imageTask);
        } else if (task instanceof ResetImageTask) {
            ResetImageTask resetPreloadTask = (ResetImageTask)task;
            image = this.createFromResetTask(resetPreloadTask);
        }
        return image;
    }

    private BufferedImage createFromResetTask(ResetImageTask task) throws BarcodeException, OptionException {
        LabelId labelId = task.getLabelId();
        LabelType labelType = labelId.getLabelType();
        Code128Code barcode = new Code128Code();
        barcode.setFontSizePt(9);
        BufferedImage barcodeImage = barcode.render(labelId.getLabelIdString(), labelType.getDisplayWidth(), 80).getImage();
        BufferedImage image = new BufferedImage(labelType.getDisplayWidth(), labelType.getDisplayHeight(), 1);
        ImageUtils.fill((BufferedImage)image, (Color)Color.WHITE);
        ImageUtils.overlay((BufferedImage)image, (BufferedImage)barcodeImage);
        return image;
    }

    public ESLImage createFromTemplateTask(TemplateTask templateTask, ExecutionStatus executionStatus, boolean debug, boolean verbose) throws SerializeException, ImageRenderingException {
        ESLImage eslImage;
        ImageTemplate imageTemplate = this.createImageTemplate(templateTask, executionStatus);
        ESLImage eSLImage = eslImage = debug ? new DebugESLImage(imageTemplate, verbose) : new ESLImage(imageTemplate, verbose);
        if (logger.isDebugEnabled()) {
            for (ExecutionStatusElement element : eslImage.getStatus().getElements()) {
                logger.warn("Warning during image rendering for label %s: %s", new Object[]{templateTask.getLabelId(), element.getElement()});
            }
        } else if (!eslImage.isSuccessful()) {
            logger.warn("At least one warning occurred during rendering image from template for label %s.", new Object[]{templateTask.getLabelId()});
        }
        return eslImage;
    }

    private ImageTemplate createImageTemplate(TemplateTask templateTask, ExecutionStatus executionStatus) throws ImageRenderingException, SerializeException {
        DOMSource recordSource = this.buildRecordSource(templateTask);
        Source templateSource = templateTask.getTemplateSource().getSource();
        File workingDirectory = templateTask.getTemplateSource().getWorkingDirectory();
        DOMSource imageSource = this.templateXMLSerializer.transformTemplate(templateSource, recordSource);
        this.templateUtilsFactory.applyUtils(((Document)imageSource.getNode()).getDocumentElement(), executionStatus);
        return this.templateXMLSerializer.parseImage(workingDirectory, imageSource, executionStatus);
    }

    private BufferedImage createFromImageTask(ImageTask task) throws SerializeException {
        return ImageSerializer.readImage((File)new File(task.getImageFilename()));
    }

    public DOMSource buildRecordSource(TemplateTask templateTask) throws ImageRenderingException {
        try {
            Document document = this.xmlToolkit.newDocument();
            Element rootElement = document.createElement("Record");
            rootElement.appendChild(this.createLabelElement(document, templateTask.getLabelId()));
            rootElement.appendChild(this.createTaskElement(document, templateTask));
            rootElement.appendChild(this.createEnvironmentElement(document));
            if (templateTask instanceof TemplateXMLTask) {
                TemplateXMLTask templateXMLTask = (TemplateXMLTask)templateTask;
                Document content = templateXMLTask.getDocument();
                Node contentNode = document.importNode(content.getDocumentElement(), true);
                this.recordSourceLogger.logRecordSource(templateTask.getLabelId(), templateTask.getExternalId(), content);
                rootElement.appendChild(contentNode);
            } else if (templateTask instanceof TemplateValuesTask) {
                TemplateValuesTask templateValuesTask = (TemplateValuesTask)templateTask;
                Element valuesElement = this.createValuesElement(document, templateValuesTask.getValues());
                rootElement.appendChild(valuesElement);
            } else {
                throw new ImageRenderingException("Unknown template task type %s", templateTask.getClass().getSimpleName());
            }
            document.appendChild(rootElement);
            return new DOMSource(document);
        }
        catch (RuntimeException exc) {
            throw new ImageRenderingException(exc);
        }
    }

    public DOMSource buildImageRenderingSource(TemplateTask templateTask) throws SerializeException, ImageRenderingException {
        DOMSource recordSource = this.buildRecordSource(templateTask);
        Source templateSource = templateTask.getTemplateSource().getSource();
        return this.templateXMLSerializer.transformTemplate(templateSource, recordSource);
    }

    private Element createValuesElement(Document document, Map<String, String> values) {
        Element element = document.createElement("Values");
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Element valueElement = document.createElement(key);
            valueElement.setTextContent(value);
            element.appendChild(valueElement);
        }
        return element;
    }

    private Element createLabelElement(Document document, LabelId labelId) {
        Element labelElement = document.createElement("Label");
        LabelType labelType = labelId.getLabelType();
        Element idElement = document.createElement("Id");
        idElement.setTextContent(labelId.getLabelIdString());
        labelElement.appendChild(idElement);
        Element labelTypeElement = document.createElement("LabelType");
        labelTypeElement.setTextContent(labelType.getName());
        labelElement.appendChild(labelTypeElement);
        Element widthElement = document.createElement("DisplayWidth");
        widthElement.setTextContent(Integer.toString(labelType.getDisplayWidth()));
        labelElement.appendChild(widthElement);
        Element heightElement = document.createElement("DisplayHeight");
        heightElement.setTextContent(Integer.toString(labelType.getDisplayHeight()));
        labelElement.appendChild(heightElement);
        Element displayColorsElement = document.createElement("DisplayColors");
        displayColorsElement.setTextContent(labelType.getDisplayColors().toString());
        labelElement.appendChild(displayColorsElement);
        Set<String> tags = this.labelTagsLookup.getTagsForLabel(labelId);
        if (!tags.isEmpty()) {
            Element tagsElement = document.createElement("Tags");
            for (String tag : tags) {
                Element tagElement = document.createElement("Tag");
                tagElement.setTextContent(tag);
                tagsElement.appendChild(tagElement);
            }
            labelElement.appendChild(tagsElement);
        }
        return labelElement;
    }

    private Element createTaskElement(Document document, TemplateTask task) {
        Element taskElement = document.createElement("Task");
        document.appendChild(taskElement);
        this.addDateTime(document, taskElement, "Current", DateTime.now());
        Element externalIdElement = document.createElement("ExternalId");
        externalIdElement.setTextContent(Long.toString(task.getExternalId()));
        taskElement.appendChild(externalIdElement);
        Element pageElement = document.createElement("Page");
        pageElement.setTextContent(task.getPage().getPageString());
        taskElement.appendChild(pageElement);
        return taskElement;
    }

    private Element createEnvironmentElement(Document document) {
        Element environmentElement = document.createElement("Environment");
        for (Map.Entry<String, String> entry : this.environmentSource.getEnvironment().entrySet()) {
            Element storeIdElement = document.createElement(entry.getKey());
            storeIdElement.setTextContent(entry.getValue());
            environmentElement.appendChild(storeIdElement);
        }
        return environmentElement;
    }

    private void addDateTime(Document document, Element element, String name, DateTime dateTime) {
        DateTimeFormatter dateFormatter = DateTimeFormat.mediumDate();
        DateTimeFormatter timeFormatter = DateTimeFormat.mediumTime();
        Element dateElement = document.createElement(name + "Date");
        dateElement.setTextContent(dateFormatter.print((ReadableInstant)dateTime));
        element.appendChild(dateElement);
        Element timeElement = document.createElement(name + "Time");
        timeElement.setTextContent(timeFormatter.print((ReadableInstant)dateTime));
        element.appendChild(timeElement);
    }
}

