/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.core.security.Puk;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.updatetask.LabelKeys;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InitializeTask
extends ExecutableTask {
    private final Map<LabelKeys, String> keys;

    public InitializeTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, String pukPassphrase, String pskPassphrase) {
        super(labelId, priority, externalId, replaceWaitingTasks);
        Puk puk = Puk.generateFromAddressAndPhrase((Address)labelId.toAddress(), (String)pukPassphrase);
        Pin pin = puk.getPin();
        Key psk = Key.deriveFromKeyAndAddress((Key)Key.generateFromPassphrase((String)pskPassphrase), (Address)labelId.toAddress());
        this.keys = new HashMap<LabelKeys, String>();
        this.keys.put(LabelKeys.PIN, pin.toHex());
        this.keys.put(LabelKeys.PUK, puk.toHex());
        this.keys.put(LabelKeys.PSK, psk.toHex());
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.PROGRAM_KEYS;
    }

    public Map<LabelKeys, String> getKeys() {
        return Collections.unmodifiableMap(this.keys);
    }
}

