/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import org.apache.commons.io.FilenameUtils;

public class FirmwareTask
extends ExecutableTask {
    private final String firmwareFilename;

    public FirmwareTask(LabelId labelId, TaskPriority priority, long externalId, boolean replaceWaitingTasks, String firmwareFilename) {
        super(labelId, priority, externalId, replaceWaitingTasks);
        this.firmwareFilename = firmwareFilename;
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.FIRMWARE;
    }

    @Override
    public String getData() {
        return this.firmwareFilename;
    }

    public String getFirmwareFilename() {
        return this.firmwareFilename;
    }

    public boolean isUpdateToLatestFirmware() {
        return this.firmwareFilename.equals("latest");
    }

    public boolean isHexFormatFile() {
        return FilenameUtils.isExtension((String)this.firmwareFilename, (String)"hex");
    }

    public boolean isXmlFormatFile() {
        return FilenameUtils.isExtension((String)this.firmwareFilename, (String)"xml");
    }
}

