/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing.gui;

import at.mrdevelopment.esl.core.DefaultLabelTypeResolver;
import at.mrdevelopment.esl.core.LabelId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class LabelConfigTableModel
extends AbstractTableModel {
    private List<LabelId> labels;
    private DefaultLabelTypeResolver resolver;

    public LabelConfigTableModel(List<LabelId> labels) {
        this.labels = new ArrayList<LabelId>(labels);
        this.resolver = new DefaultLabelTypeResolver();
    }

    @Override
    public int getRowCount() {
        return this.labels.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Label ID";
        }
        return "Type";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return LabelId.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.labels.get(rowIndex);
        }
        return this.resolver.getLabelType(this.labels.get(rowIndex).toAddress()).getName();
    }

    public List<LabelId> getLabels() {
        return new ArrayList<LabelId>(this.labels);
    }

    public void addLabel(final LabelId labelId) {
        if (!this.labels.contains(labelId)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LabelConfigTableModel.this.labels.add(labelId);
                    LabelConfigTableModel.this.fireTableRowsInserted(LabelConfigTableModel.this.labels.size() - 1, LabelConfigTableModel.this.labels.size() - 1);
                }
            });
        }
    }

    public void addLabels(Collection<LabelId> allLabels) {
        for (LabelId labelId : allLabels) {
            this.addLabel(labelId);
        }
    }

    public void removeLabel(final LabelId labelId) {
        final int index = this.labels.indexOf(labelId);
        if (index >= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LabelConfigTableModel.this.labels.remove(labelId);
                    LabelConfigTableModel.this.fireTableRowsDeleted(index, index);
                }
            });
        }
    }

    public void clearLabels() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int size = LabelConfigTableModel.this.labels.size();
                if (size > 0) {
                    LabelConfigTableModel.this.labels.clear();
                    LabelConfigTableModel.this.fireTableDataChanged();
                }
            }
        });
    }

    public LabelId getLabelId(int index) {
        return this.labels.get(index);
    }
}

