/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing.gui;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.csvimport.LabelRegistrationCsvImport;
import at.mrdevelopment.esl.gui.LabelIdTableCellRenderer;
import at.mrdevelopment.esl.gui.editor.LabelIdEditor;
import at.mrdevelopment.esl.processing.gui.LabelConfigTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class LabelConfigTab {
    private JPanel mainPanel;
    private JTable table;
    private LabelIdEditor labelEditor;
    private LabelConfigTableModel model;
    private JButton removeButton;
    private JButton clearButton;
    private LabelRegistrationCsvImport labelImport = new LabelRegistrationCsvImport();

    public LabelConfigTab(List<LabelId> labels) {
        this.mainPanel = new JPanel(new BorderLayout());
        this.model = new LabelConfigTableModel(labels);
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(LabelId.class, new LabelIdTableCellRenderer());
        this.table.setAutoCreateRowSorter(true);
        this.table.setFillsViewportHeight(true);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LabelConfigTab.this.selectionChanged();
            }
        });
        this.mainPanel.add((Component)new JScrollPane(this.table), "Center");
        JPanel topPanel = new JPanel(new FlowLayout());
        topPanel.add(new JLabel("Label ID:"));
        this.labelEditor = new LabelIdEditor(false);
        topPanel.add(this.labelEditor.getEditorComponent());
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelConfigTab.this.onAddButton();
            }
        });
        JComponent editorComponent = this.labelEditor.getEditorComponent();
        editorComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    LabelConfigTab.this.onAddButton();
                }
            }
        });
        topPanel.add(addButton);
        this.mainPanel.add((Component)topPanel, "North");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton importButton = new JButton("Import");
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelConfigTab.this.onImportButton();
            }
        });
        buttonPanel.add(importButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelConfigTab.this.onRemoveButton();
            }
        });
        this.removeButton.setEnabled(false);
        buttonPanel.add(this.removeButton);
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelConfigTab.this.onClearButton();
            }
        });
        this.clearButton.setEnabled(labels.size() > 0);
        buttonPanel.add(this.clearButton);
        this.mainPanel.add((Component)buttonPanel, "South");
    }

    protected void selectionChanged() {
        if (this.table.getSelectedRowCount() > 0) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    protected void onClearButton() {
        this.model.clearLabels();
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
    }

    protected void onRemoveButton() {
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<LabelId> labels = new ArrayList<LabelId>();
        for (int index : selectedRows) {
            labels.add(this.model.getLabelId(this.table.convertRowIndexToModel(index)));
        }
        for (LabelId labelId : labels) {
            this.model.removeLabel(labelId);
        }
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
    }

    protected void onImportButton() {
        JFileChooser fileChooser = new JFileChooser("data");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileFilter(new FileNameExtensionFilter("Label files (*.csv)", "csv"));
        int result = fileChooser.showOpenDialog(this.mainPanel);
        if (result == 0) {
            try {
                File[] labelFiles = fileChooser.getSelectedFiles();
                ArrayList<LabelId> allLabels = new ArrayList<LabelId>();
                for (File labelFile : labelFiles) {
                    List registrations = this.labelImport.importFromFile(labelFile);
                    ArrayList<LabelId> labels = new ArrayList<LabelId>(registrations.size());
                    for (LabelRegistration registration : registrations) {
                        labels.add(registration.getLabelId());
                    }
                    allLabels.addAll(labels);
                }
                this.model.addLabels(allLabels);
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(this.mainPanel, exc.getMessage(), exc.getClass().getSimpleName(), 0);
            }
        }
    }

    protected void onAddButton() {
        this.labelEditor.validate();
        if (!this.labelEditor.hasErrors()) {
            LabelId labelId = this.labelEditor.getLabelId();
            this.model.addLabel(labelId);
            this.clearButton.setEnabled(true);
            this.labelEditor.clear();
        }
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    public List<LabelId> getLabels() {
        return this.model.getLabels();
    }
}

