/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing.gui;

import at.mrdevelopment.Pair;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.processing.ConfigChangeListener;
import at.mrdevelopment.esl.processing.ConfigChangeNotifier;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.xml.LabelXMLSerializer;
import at.mrdevelopment.esl.xml.ServiceAddressAndLabelXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Range;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class EditConfigManager
implements ConfigChangeNotifier {
    private Set<ConfigChangeListener> listeners = new HashSet<ConfigChangeListener>();
    private File accessPointConfigFile;
    private File labelConfigFile;
    private ServiceAddressAndLabelXMLSerializer serializer;
    private LabelXMLSerializer labelSerializer;
    private XMLToolkit xmlToolkit;

    public EditConfigManager(File accessPointConfigFile, File labelConfigFile) throws InitializationException {
        this.accessPointConfigFile = accessPointConfigFile;
        this.labelConfigFile = labelConfigFile;
        this.serializer = new ServiceAddressAndLabelXMLSerializer();
        this.labelSerializer = new LabelXMLSerializer();
        this.xmlToolkit = new XMLToolkit();
    }

    @Override
    public void registerConfigChangeListener(ConfigChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterConfigChangeListener(ConfigChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyAccessPointConfigChanged() {
        for (ConfigChangeListener listener : this.listeners) {
            listener.accessPointConfigChanged();
        }
    }

    public void notifyLabelsConfigChanged(List<LabelId> selectedLabels) {
        for (ConfigChangeListener listener : this.listeners) {
            listener.labelConfigChanged(selectedLabels);
        }
    }

    public Map<String, Collection<ServiceAddress>> loadAccessPoints() throws FileNotFoundException, SerializeException {
        return this.serializer.parseServiceAddresses(this.accessPointConfigFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LabelId> loadLabels() throws FileNotFoundException, SerializeException {
        ArrayList<LabelId> arrayList;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.labelConfigFile);
            arrayList = new ArrayList<LabelId>(this.labelSerializer.parseXML(stream));
        }
        catch (Throwable throwable) {
            StreamUtils.close(stream);
            throw throwable;
        }
        StreamUtils.close((InputStream)stream);
        return arrayList;
    }

    public void storeAccessPoints(Map<String, Collection<ServiceAddress>> accessPointMap) throws SerializeException {
        this.serializer.storeServiceAddress(accessPointMap, this.accessPointConfigFile);
        this.notifyAccessPointConfigChanged();
    }

    public void storeLabels(List<Pair<Range<String>, Boolean>> labels, List<Address> selectedLabels) throws SerializeException {
        this.serializer.storeLabelData(labels, this.labelConfigFile);
    }

    public void storeLabels(List<LabelId> labels) throws SerializeException {
        Document document = this.labelSerializer.toXML(labels);
        this.xmlToolkit.transform((Source)new DOMSource(document), (Result)new StreamResult(this.labelConfigFile));
        this.notifyLabelsConfigChanged(labels);
    }
}

