/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing;

import at.mrdevelopment.esl.accesspoint.AccessPointReplyCallback;
import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.core.AbstractESLProcessing;
import at.mrdevelopment.esl.core.DefaultReloadRunner;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.PeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ReloadRunner;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.core.TasksSubmittedNotify;
import at.mrdevelopment.esl.core.UpdateTaskListener;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.DatasetModifiedListener;
import at.mrdevelopment.esl.persistence.WebserviceDatasetRegistry;
import at.mrdevelopment.esl.persistence.dataset.IndexedDataset;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.processing.AddTaskListener;
import at.mrdevelopment.esl.processing.LabelInfoListener;
import at.mrdevelopment.esl.processing.ServiceStatusListener;
import at.mrdevelopment.esl.processing.SimpleAccessPointUpdateTaskGenerator;
import at.mrdevelopment.esl.processing.SimpleESLProcessing;
import at.mrdevelopment.esl.processing.TaskAbortedListener;
import at.mrdevelopment.esl.processing.TaskErrorListener;
import at.mrdevelopment.esl.processing.UpdateTaskGenerator;
import at.mrdevelopment.esl.service.ServiceClient;
import at.mrdevelopment.esl.tasks.AbortRequest;
import at.mrdevelopment.esl.tasks.ErrorTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.UpdateImageFactory;
import at.mrdevelopment.esl.type.Transaction;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.esl.updatetask.UpdateTaskFactory;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.Abortable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class SimpleESLServerProcessing
extends AbstractESLProcessing
implements AccessPointReplyCallback,
DatasetModifiedListener<AccessPointInfo>,
TasksSubmittedNotify,
UpdateTaskGenerator,
AddTaskListener,
TaskErrorListener,
UpdateTaskListener {
    static ESLLogger logger = ESLLogger.getLogger(SimpleESLServerProcessing.class);
    private ServiceClient serviceClient;
    private boolean runInBackground;
    private int maxProcessingIterations = 0;
    private int currentProcessingIteration = 0;
    private int currentPingIntervalInMinutes;
    private boolean sendAcceptAllLabels = false;
    private Map<LabelId, Integer> labelMapping = new HashMap<LabelId, Integer>();
    private Map<Integer, SimpleAccessPointUpdateTaskGenerator> accessPoints = new ConcurrentHashMap<Integer, SimpleAccessPointUpdateTaskGenerator>();
    private IndexedDataset<AccessPointInfo> accessPointDataset;
    private IndexedDataset<Configuration> serverConfigurationDataset;
    private Map<Integer, List<Task>> waitingTasks;
    private boolean runWithoutTasks = true;
    private boolean accessPointRecordsQueried = false;
    private UpdateTaskFactory updateTaskFactory;
    private Set<UpdateTaskListener> updateTaskListeners = new CopyOnWriteArraySet<UpdateTaskListener>();
    private Set<ServiceStatusListener> serviceStatusListeners = new CopyOnWriteArraySet<ServiceStatusListener>();
    private Set<AddTaskListener> addTaskListeners = new CopyOnWriteArraySet<AddTaskListener>();
    private Set<TaskErrorListener> taskErrorListeners = new CopyOnWriteArraySet<TaskErrorListener>();
    private Set<TaskAbortedListener> taskAbortedListeners = new CopyOnWriteArraySet<TaskAbortedListener>();
    private Set<LabelInfoListener> labelInfoListeners = new CopyOnWriteArraySet<LabelInfoListener>();
    private Collection<UUID> tasksToAbort = new CopyOnWriteArraySet<UUID>();

    public SimpleESLServerProcessing(String host, int port, boolean useSSL, String username, String password, int maxProcessingIterations, boolean runInBackground, boolean sendAcceptAllLabels) throws InitializationException {
        this.maxProcessingIterations = maxProcessingIterations;
        this.updateTaskFactory = new UpdateTaskFactory(new UpdateImageFactory(), true);
        this.serviceClient = new ServiceClient(host, port, useSSL);
        this.serviceClient.setCredentials(username, password);
        this.runInBackground = runInBackground;
        this.sendAcceptAllLabels = sendAcceptAllLabels;
        WebserviceDatasetRegistry datasetRegistry = new WebserviceDatasetRegistry(this.serviceClient.getHttpServiceClient());
        this.accessPointDataset = datasetRegistry.registerDataset(AccessPointInfo.class);
        this.accessPointDataset.addDatasetModifiedListener((DatasetModifiedListener)this);
        this.serverConfigurationDataset = datasetRegistry.registerDataset(Configuration.class);
    }

    @Override
    public void start() {
        if (this.hasProcessingTasks()) {
            throw new IllegalStateException("Processing already started");
        }
        this.createProcessingTasks();
        if (this.runInBackground) {
            ReloadRunner.startInBackground((ReloadRunner)new DefaultReloadRunner((PeriodicTasksExecutor)this, 5000L), (boolean)true);
        } else {
            ReloadRunner.startInCurrentThread((ReloadRunner)new DefaultReloadRunner((PeriodicTasksExecutor)this, 5000L));
        }
    }

    private void createProcessingTasks() {
        this.addProcessingTask(new ESLProcessingTask(){

            public void run() throws Exception {
                block12: {
                    try {
                        Abortable abortable;
                        if (SimpleESLServerProcessing.this.maxProcessingIterations > 0 && SimpleESLServerProcessing.this.currentProcessingIteration >= SimpleESLServerProcessing.this.maxProcessingIterations) break block12;
                        try {
                            SimpleESLServerProcessing.this.serviceClient.queryServiceStatus();
                            SimpleESLServerProcessing.this.notifyServiceStatusReceived(SimpleESLServerProcessing.this.serviceClient.getServiceStatus());
                        }
                        catch (Exception exc) {
                            logger.warn("Error processing service status: %s", new Object[]{exc.getMessage()});
                            logger.logExceptionIfDebugEnabled((Throwable)exc);
                        }
                        try {
                            abortable = SimpleESLServerProcessing.this.accessPointDataset.reload();
                            abortable.waitUntilFinished();
                        }
                        catch (Exception exc) {
                            logger.warn("Error processing access points: %s", new Object[]{exc.getMessage()});
                            logger.logExceptionIfDebugEnabled((Throwable)exc);
                        }
                        try {
                            abortable = SimpleESLServerProcessing.this.serverConfigurationDataset.reload();
                            abortable.waitUntilFinished();
                            SimpleESLServerProcessing.this.processServerConfiguration();
                        }
                        catch (Exception exc) {
                            logger.warn("Error processing server configuration: %s", new Object[]{exc.getMessage()});
                            logger.logExceptionIfDebugEnabled((Throwable)exc);
                        }
                        try {
                            SimpleESLServerProcessing.this.processLabelInfoList(SimpleESLServerProcessing.this.serviceClient.queryLabelInfo());
                        }
                        catch (Exception exc) {
                            logger.warn("Error processing labels: %s", new Object[]{exc.getMessage()});
                            logger.logExceptionIfDebugEnabled((Throwable)exc);
                        }
                        if (SimpleESLServerProcessing.this.accessPointRecordsQueried) {
                            if (!SimpleESLServerProcessing.this.tasksToAbort.isEmpty()) {
                                SimpleESLServerProcessing.this.abortTasks();
                            }
                            SimpleESLServerProcessing.this.addWaitingTasks();
                        }
                    }
                    catch (Exception exc) {
                        logger.warn("Error during processing: %s", new Object[]{exc.getMessage()});
                        logger.logExceptionIfDebugEnabled((Throwable)exc);
                    }
                }
            }
        });
    }

    private void abortTasks() {
        for (SimpleAccessPointUpdateTaskGenerator accessPoint : this.accessPoints.values()) {
            accessPoint.abortTasks(this.tasksToAbort);
        }
    }

    protected void processServerConfiguration() throws DatasetException {
        QueryResult queryResult = this.serverConfigurationDataset.getDefaultQuery().getResult(QueryRestriction.newUnpagedQuery());
        List configurationEntries = queryResult.getRecords();
        for (Configuration configuration : configurationEntries) {
            if (!configuration.getName().equals("pingLabelsIntervalInMinutes")) continue;
            this.currentPingIntervalInMinutes = Integer.valueOf(configuration.getValue());
            return;
        }
    }

    protected void updateAccessPointServices(Collection<AccessPointInfo> newAccessPointInfos) {
        Integer accessPointId;
        HashMap<Integer, AccessPointInfo> accessPointInfos = new HashMap<Integer, AccessPointInfo>();
        for (AccessPointInfo accessPointInfo : newAccessPointInfos) {
            accessPointId = accessPointInfo.getAccessPointId();
            if (accessPointId == null) continue;
            accessPointInfos.put(accessPointId, accessPointInfo);
        }
        this.removeAccessPointsNotInDataset(accessPointInfos);
        for (AccessPointInfo accessPointInfo : newAccessPointInfos) {
            accessPointId = accessPointInfo.getAccessPointId();
            if (accessPointId == null || this.accessPoints.containsKey(accessPointId) || !accessPointInfo.isOffline() && !accessPointInfo.isOnline()) continue;
            try {
                ServiceAddress serviceAddress = ServiceAddress.fromString((String)accessPointInfo.getAddress());
                SimpleAccessPointUpdateTaskGenerator simpleAccessPointUpdateTaskGenerator = new SimpleAccessPointUpdateTaskGenerator(serviceAddress.getConnectionString(), 0, true, this.sendAcceptAllLabels);
                simpleAccessPointUpdateTaskGenerator.registerUpdateTaskListener(this);
                simpleAccessPointUpdateTaskGenerator.registerAddTaskListener(this);
                simpleAccessPointUpdateTaskGenerator.registerTaskErrorListener(this);
                simpleAccessPointUpdateTaskGenerator.start();
                this.accessPoints.put(accessPointId, simpleAccessPointUpdateTaskGenerator);
            }
            catch (MalformedURLException exc) {
                logger.warn("Could not create service address for address %s", new Object[]{accessPointInfo.getAddress()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            catch (InitializationException exc) {
                logger.warn("Could not create Access Point processing for Access Point %d", new Object[]{accessPointId});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
    }

    private void removeAccessPointsNotInDataset(Map<Integer, AccessPointInfo> accessPointInfos) {
        ArrayList<Integer> accessPointsToRemove = new ArrayList<Integer>();
        for (Integer accessPointId : this.accessPoints.keySet()) {
            if (accessPointInfos.containsKey(accessPointId)) continue;
            accessPointsToRemove.add(accessPointId);
        }
        ArrayList<Task> waitingTasks = new ArrayList<Task>();
        for (Integer accessPointId : accessPointsToRemove) {
            waitingTasks.addAll(this.removeAccessPointProcessing(accessPointId));
        }
        if (waitingTasks.size() > 0) {
            this.notifyTasksAborted(waitingTasks);
        }
    }

    private Collection<Task> removeAccessPointProcessing(Integer accessPointId) {
        logger.info("Removing Access Point %d from processing", new Object[]{accessPointId});
        SimpleAccessPointUpdateTaskGenerator updateTaskGenerator = this.accessPoints.get(accessPointId);
        if (updateTaskGenerator != null) {
            Collection<Task> waitingTasks = updateTaskGenerator.getWaitingTasks();
            updateTaskGenerator.shutdown();
            this.accessPoints.remove(accessPointId);
            return waitingTasks;
        }
        return Collections.emptyList();
    }

    protected void processLabelInfoList(Collection<LabelInfo> labelInfoList) {
        ArrayList<WakeupStatistic> wakeupStatistics = new ArrayList<WakeupStatistic>();
        for (LabelInfo labelInfo : labelInfoList) {
            this.labelMapping.put(labelInfo.toLabelId(), labelInfo.getAccessPointId());
            if (labelInfo.getWakeupTime() != null && labelInfo.getFirmwareVersion() != null && labelInfo.getSyncQuality() != null && labelInfo.getPowerStatus() != null && labelInfo.getCurrentPage() != null && labelInfo.getLabelErrors() != null && labelInfo.getRssi() != null && labelInfo.getLqi() != null) {
                wakeupStatistics.add(new WakeupStatistic(labelInfo.toAddress(), labelInfo.getAccessPointId().intValue(), 1L, labelInfo.getWakeupTime(), labelInfo.getWakeupTime(), labelInfo.getFirmwareVersion(), labelInfo.getSyncQuality(), labelInfo.getPowerStatus(), false, false, labelInfo.getCurrentPage(), labelInfo.getLabelErrors(), labelInfo.getRssi(), labelInfo.getLqi()));
                continue;
            }
            wakeupStatistics.add(new WakeupStatistic(labelInfo.toAddress(), 0));
        }
        this.processWakeupStatistics(wakeupStatistics);
        for (LabelInfoListener listener : this.labelInfoListeners) {
            listener.receivedLabelInfos(labelInfoList);
        }
    }

    @Override
    public void registerLabelInfoListener(LabelInfoListener listener) {
        this.labelInfoListeners.add(listener);
    }

    @Override
    public void unregisterLabelInfoListener(LabelInfoListener listener) {
        this.labelInfoListeners.remove(listener);
    }

    public void notifyLabelInfo(LabelInfo labelInfo) {
        List<LabelInfo> labelInfos = Collections.singletonList(labelInfo);
        for (LabelInfoListener listener : this.labelInfoListeners) {
            listener.receivedLabelInfos(labelInfos);
        }
    }

    @Override
    public void processServiceStatus(AccessPointService accessPointService, AccessPointServiceStatus serviceStatus) {
        this.notifyServiceStatusReceived(serviceStatus.getServiceStatus());
    }

    @Override
    public void processWakeupStatistics(Collection<WakeupStatistic> receivedWakeupStatistics) {
        for (WakeupStatistic wakeupStatistic : receivedWakeupStatistics) {
            this.notifyReceivedWakeup(wakeupStatistic);
        }
    }

    @Override
    public void processJoinRequests(Collection<JoinRequest> joinRequests) {
    }

    @Override
    public void failedToQueryAccessPoint(AccessPointService accessPointService) {
    }

    @Override
    public void processUpdateTasks(int accessPointId, Collection<UpdateTask> receivedUpdateTasks) throws DatasetException {
    }

    @Override
    public void processTask(Transaction transaction, Task task) throws DatasetException, SerializeException {
    }

    @Override
    public void processErrorTask(Transaction transaction, ErrorTask task) throws DatasetException, SerializeException {
    }

    @Override
    public void shutdown() {
        this.runWithoutTasks = false;
        for (SimpleAccessPointUpdateTaskGenerator updateTaskGenerator : this.accessPoints.values()) {
            updateTaskGenerator.shutdown();
        }
        super.shutdown();
    }

    public void tasksSubmitted(Transaction transaction, int taskCount) {
    }

    @Override
    public void addTasks(Collection<? extends Task> tasks) {
        Integer value;
        if (this.waitingTasks == null) {
            this.waitingTasks = new ConcurrentHashMap<Integer, List<Task>>();
        }
        if (!this.waitingTasks.containsKey(value = new Integer(0))) {
            this.waitingTasks.put(value, new ArrayList());
        }
        this.waitingTasks.get(value).addAll(tasks);
    }

    private void notifyServiceStatusReceived(ServiceStatus serviceStatus) {
        for (ServiceStatusListener listener : this.serviceStatusListeners) {
            listener.notifyServiceStatus(serviceStatus);
        }
    }

    private void addWaitingTasks() {
        if (this.waitingTasks != null) {
            for (Integer retryCount : this.waitingTasks.keySet()) {
                Map<Integer, List<Task>> taskMap = this.distributeTasksToAccessPoints((Collection<? extends Task>)this.waitingTasks.get(retryCount));
                ArrayList<Integer> accessPointsNotInList = new ArrayList<Integer>();
                for (Integer accessPointId : taskMap.keySet()) {
                    if (this.accessPoints.containsKey(accessPointId)) {
                        if (retryCount == 0) {
                            this.accessPoints.get(accessPointId).addTasks((Collection<? extends Task>)taskMap.get(accessPointId));
                            continue;
                        }
                        this.accessPoints.get(accessPointId).taskGenerated((Collection<? extends Task>)taskMap.get(accessPointId), retryCount);
                        this.notifyAddTaskListener((Collection<? extends Task>)taskMap.get(accessPointId), retryCount);
                        continue;
                    }
                    accessPointsNotInList.add(accessPointId);
                }
                if (accessPointsNotInList.size() <= 0) continue;
                this.generateErrorTasks(accessPointsNotInList, taskMap);
            }
            this.waitingTasks.clear();
        }
    }

    private void notifyAddTaskListener(Collection<? extends Task> tasks, Integer retryCount) {
        for (AddTaskListener listener : this.addTaskListeners) {
            listener.taskAdded(tasks, retryCount);
        }
    }

    @Override
    public boolean isFinished() {
        boolean requested = !this.runWithoutTasks || this.waitingTasks != null && this.waitingTasks.size() == 0;
        for (SimpleAccessPointUpdateTaskGenerator updateTaskGenerator : this.accessPoints.values()) {
            requested = requested && updateTaskGenerator.isFinished();
        }
        return requested;
    }

    private Map<Integer, List<Task>> distributeTasksToAccessPoints(Collection<? extends Task> tasks) {
        HashMap<Integer, List<Task>> taskMap = new HashMap<Integer, List<Task>>();
        for (Task task : tasks) {
            Integer accessPointId = this.labelMapping.get(task.getLabelId());
            if (accessPointId == null) {
                accessPointId = -1;
            }
            if (!taskMap.containsKey(accessPointId)) {
                taskMap.put(accessPointId, new ArrayList());
            }
            ((List)taskMap.get(accessPointId)).add(task);
        }
        return taskMap;
    }

    private void notifyTasksAborted(Collection<Task> tasks) {
        for (TaskAbortedListener listener : this.taskAbortedListeners) {
            listener.tasksAborted(tasks);
        }
    }

    @Override
    public void taskGenerated(Collection<? extends Task> tasks, int retryCount) {
        if (this.waitingTasks == null) {
            this.waitingTasks = new ConcurrentHashMap<Integer, List<Task>>();
        }
        if (!this.waitingTasks.containsKey(retryCount)) {
            this.waitingTasks.put(retryCount, new ArrayList());
        }
        this.waitingTasks.get(retryCount).addAll(tasks);
        this.notifyAddTaskListener(tasks, retryCount);
    }

    private void generateErrorTasks(List<Integer> accessPointsNotInList, Map<Integer, List<Task>> taskMap) {
        for (Integer accessPointId : accessPointsNotInList) {
            logger.info("Access Point %s not configured. Setting tasks to error.", new Object[]{accessPointId});
            Collection taskList = taskMap.get(accessPointId);
            for (Task task : taskList) {
                ErrorTask errorTask = new ErrorTask(task, UpdateError.ERROR_CODE_UNKNOWN);
                UUID taskId = UUID.randomUUID();
                UpdateTask updateTask = SimpleESLProcessing.convertToUpdateTask(task, taskId, this.updateTaskFactory);
                updateTask.changeStatus(UpdateTaskStatus.ERROR, errorTask.getUpdateError());
                this.notifyErrorTaskAdded(errorTask, updateTask);
            }
        }
    }

    public void registerUpdateTaskListener(UpdateTaskListener listener) {
        this.updateTaskListeners.add(listener);
    }

    public void unregisterUpdateTaskListener(UpdateTaskListener listener) {
        this.updateTaskListeners.remove(listener);
    }

    @Override
    public int getCurrentPingIntervalInMinutes() {
        return this.currentPingIntervalInMinutes;
    }

    @Override
    public Collection<Task> getWaitingTasks() {
        HashSet<Task> currentWaitingTasks = new HashSet<Task>();
        if (this.waitingTasks != null) {
            for (List list : this.waitingTasks.values()) {
                currentWaitingTasks.addAll(list);
            }
        }
        for (SimpleAccessPointUpdateTaskGenerator simpleAccessPointUpdateTaskGenerator : this.accessPoints.values()) {
            currentWaitingTasks.addAll(simpleAccessPointUpdateTaskGenerator.getWaitingTasks());
        }
        return currentWaitingTasks;
    }

    @Override
    public void setLabelsForSendingRoamingTable(List<Address> addresses, boolean forceSendRoamingTable) {
        logger.info("Not supported in this mode: setLabelsForSendingRoamingTable");
    }

    @Override
    public void removeAllLabelsFromAccessPoint() {
        logger.info("Not supported in this mode: removeAllLabelsFromAccessPoint");
    }

    @Override
    public void removeAllWaitingTasksFromAccessPoint() {
        logger.info("Not supported in this mode: removeAllWaitingTasksFromAccessPoint");
    }

    @Override
    public void setPingIntervalInMinutes(int pingIntervalInMinutes) {
        logger.info("Not supported in this mode: setPingIntervalInMinutes");
    }

    @Override
    public void setRoamingValidTimeInMinutes(int roamingValidTimeInMinutes) {
        logger.info("Not supported in this mode: setRoamingValidTimeInMinutes");
    }

    @Override
    public Task getTaskForTaskId(UUID taskId) {
        for (SimpleAccessPointUpdateTaskGenerator updateTaskGenerator : this.accessPoints.values()) {
            Task task = updateTaskGenerator.getTaskForTaskId(taskId);
            if (task == null) continue;
            return task;
        }
        return null;
    }

    public void updateTaskAdded(UpdateTask updateTask) {
        if (this.updateTaskListeners != null) {
            for (UpdateTaskListener listener : this.updateTaskListeners) {
                listener.updateTaskAdded(updateTask);
            }
        }
    }

    public void updateTaskChanged(UpdateTask updateTask) {
        if (this.updateTaskListeners != null) {
            for (UpdateTaskListener listener : this.updateTaskListeners) {
                listener.updateTaskChanged(updateTask);
            }
        }
    }

    public void updateTaskRemoved(UpdateTask updateTask) {
        if (this.updateTaskListeners != null) {
            for (UpdateTaskListener listener : this.updateTaskListeners) {
                listener.updateTaskRemoved(updateTask);
            }
        }
    }

    @Override
    public void notifyErrorTaskAdded(ErrorTask errorTask, UpdateTask updateTask) {
        if (this.taskErrorListeners != null) {
            for (TaskErrorListener listener : this.taskErrorListeners) {
                listener.notifyErrorTaskAdded(errorTask, updateTask);
            }
        }
    }

    @Override
    public void taskAdded(Collection<? extends Task> tasks, int retryCount) {
    }

    @Override
    public void setRunWithoutTasks(boolean runWithoutTasks) {
        this.runWithoutTasks = runWithoutTasks;
    }

    public void recordsModified(Collection<AccessPointInfo> records) {
        this.updateAccessPointServices(records);
        this.accessPointRecordsQueried = true;
    }

    @Override
    public void unregisterServiceStatusListener(ServiceStatusListener serviceStatusListener) {
        this.serviceStatusListeners.remove(serviceStatusListener);
    }

    @Override
    public void registerServiceStatusListener(ServiceStatusListener listener) {
        this.serviceStatusListeners.add(listener);
    }

    @Override
    public void unregisterAddTaskListener(AddTaskListener listener) {
        this.addTaskListeners.remove(listener);
    }

    @Override
    public void registerAddTaskListener(AddTaskListener listener) {
        this.addTaskListeners.add(listener);
    }

    @Override
    public void unregisterTaskErrorListener(TaskErrorListener listener) {
        this.taskErrorListeners.remove(listener);
    }

    @Override
    public void registerTaskErrorListener(TaskErrorListener listener) {
        this.taskErrorListeners.add(listener);
    }

    @Override
    public void unregisterTaskAbortedListener(TaskAbortedListener listener) {
        this.taskAbortedListeners.remove(listener);
    }

    @Override
    public void registerTaskAbortedListener(TaskAbortedListener listener) {
        this.taskAbortedListeners.add(listener);
    }

    @Override
    public void setProcessingIterations(int maxProcessingIterations) {
        this.maxProcessingIterations = maxProcessingIterations;
    }

    @Override
    public void scheduleTask(Transaction transaction, Task task) {
    }

    @Override
    public void scheduleAbortRequest(AbortRequest abortRequest) {
    }

    @Override
    public void processAbortRequest(AbortRequest abortRequest) {
    }

    @Override
    public void processLabelEvents(int accessPointId, Collection<LabelEvent> labelEvents) {
    }

    @Override
    public void abortTasks(Collection<UUID> taskIds) {
        this.tasksToAbort.addAll(taskIds);
    }
}

