/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing;

import at.mrdevelopment.esl.accesspoint.AccessPointReplyCallback;
import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceClient;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceFactory;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.core.AbstractESLProcessing;
import at.mrdevelopment.esl.core.DefaultReloadRunner;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.PeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ReloadRunner;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.UpdateCreationException;
import at.mrdevelopment.esl.core.UpdateTaskListener;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.processing.SimpleTransaction;
import at.mrdevelopment.esl.tasks.AbortRequest;
import at.mrdevelopment.esl.tasks.ErrorTask;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.InternalTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.UpdateImageFactory;
import at.mrdevelopment.esl.type.TaskQueueEntry;
import at.mrdevelopment.esl.type.TaskQueueEntryPriorityComparator;
import at.mrdevelopment.esl.type.Transaction;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.esl.updatetask.UpdateTaskFactory;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.ChannelTableEntry;
import at.mrdevelopment.esl.wireless.RoamingAssignment;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;

public abstract class SimpleESLProcessing
extends AbstractESLProcessing
implements AccessPointReplyCallback {
    static ESLLogger logger = ESLLogger.getLogger(SimpleESLProcessing.class);
    private static int DEFAULT_PING_INTERVALL_IN_MINUTES = 1;
    private static int DEFAULT_ROAMING_VALID_TIME_IN_MINUTES = 10;
    private static final Version OLD_VERSION = Version.fromString((String)"1.0.4");
    private AccessPointService accessPointService;
    private WirelessChannel wirelessChannel = null;
    protected UpdateTaskFactory updateTaskFactory = new UpdateTaskFactory(new UpdateImageFactory(), true);
    private Map<UUID, Task> waitingTasks = new ConcurrentHashMap<UUID, Task>();
    private boolean allowRetries = true;
    protected int maxProcessingIterations = 0;
    private int currentProcessingIteration = 0;
    private boolean runWithoutTasks = false;
    private List<Address> labelAddresses = new ArrayList<Address>();
    private boolean runInBackGround = false;
    private List<UpdateTaskListener> updateTaskListeners = new LinkedList<UpdateTaskListener>();
    private long sendRoamingTableInterval = 180000L;
    private long lastRoamingTableSent = 0L;
    private boolean forceSendRoamingTable = false;
    private int roamingValidTimeInMinutes;
    private int pingIntervalInMinutes;
    private boolean sendAcceptAllLabels = false;
    private Collection<UUID> tasksToAbort = Sets.newSetFromMap(new ConcurrentHashMap());
    private final PriorityBlockingQueue<TaskQueueEntry> scheduledTasks = new PriorityBlockingQueue<TaskQueueEntry>(100, new TaskQueueEntryPriorityComparator());

    public SimpleESLProcessing(String accessPointConnectionString) throws InitializationException {
        this(accessPointConnectionString, true, 0, false, false, DEFAULT_ROAMING_VALID_TIME_IN_MINUTES, DEFAULT_PING_INTERVALL_IN_MINUTES, false);
    }

    public SimpleESLProcessing(String accessPointConnectionString, boolean allowRetries, int maxProcessingIterations, boolean runWithoutTasks, boolean runInBackGround, boolean sendAcceptAllLabels) throws InitializationException {
        this(accessPointConnectionString, allowRetries, maxProcessingIterations, runWithoutTasks, runInBackGround, DEFAULT_ROAMING_VALID_TIME_IN_MINUTES, DEFAULT_PING_INTERVALL_IN_MINUTES, sendAcceptAllLabels);
    }

    public SimpleESLProcessing(String accessPointConnectionString, boolean allowRetries, int maxProcessingIterations, boolean runWithoutTasks, boolean runInBackGround, int roamingValidTimeInMinutes, int pingIntervalInMinutes, boolean sendAcceptAllLabels) throws InitializationException {
        this.allowRetries = allowRetries;
        this.sendAcceptAllLabels = sendAcceptAllLabels;
        this.runWithoutTasks = runWithoutTasks;
        this.runInBackGround = runInBackGround;
        this.roamingValidTimeInMinutes = roamingValidTimeInMinutes;
        this.pingIntervalInMinutes = pingIntervalInMinutes;
        this.maxProcessingIterations = maxProcessingIterations;
        try {
            AccessPointServiceFactory accessPointServiceFactory = new AccessPointServiceFactory();
            ServiceAddress accessPointAddress = accessPointServiceFactory.loadAddress(accessPointConnectionString);
            Collection<AccessPointService> accessPointServices = accessPointServiceFactory.createServiceInstances(Collections.singleton(accessPointAddress));
            this.accessPointService = new ArrayList<AccessPointService>(accessPointServices).get(0);
        }
        catch (InitializationException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    @Override
    public void start() {
        if (this.hasProcessingTasks()) {
            throw new IllegalStateException("Processing already started");
        }
        this.createProcessingTasks();
        if (this.runInBackGround) {
            ReloadRunner.startInBackground((ReloadRunner)new DefaultReloadRunner((PeriodicTasksExecutor)this, 5000L), (boolean)true);
        } else {
            ReloadRunner.startInCurrentThread((ReloadRunner)new DefaultReloadRunner((PeriodicTasksExecutor)this, 5000L));
        }
    }

    protected void createProcessingTasks() {
        this.addProcessingTask(new ESLProcessingTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Exception {
                if (SimpleESLProcessing.this.maxProcessingIterations <= 0 || SimpleESLProcessing.this.currentProcessingIteration < SimpleESLProcessing.this.maxProcessingIterations) {
                    SimpleESLProcessing.this.currentProcessingIteration++;
                    SimpleESLProcessing.this.accessPointService.queryServiceStatus(SimpleESLProcessing.this);
                    List list = SimpleESLProcessing.this.labelAddresses;
                    synchronized (list) {
                        long currentTime = System.currentTimeMillis();
                        if (SimpleESLProcessing.this.forceSendRoamingTable || (SimpleESLProcessing.this.labelAddresses.size() > 0 || SimpleESLProcessing.this.sendAcceptAllLabels) && currentTime - SimpleESLProcessing.this.lastRoamingTableSent >= SimpleESLProcessing.this.sendRoamingTableInterval) {
                            try {
                                SimpleESLProcessing.this.accessPointService.sendRoamingTable(SimpleESLProcessing.this.createRoamingTable());
                                SimpleESLProcessing.this.lastRoamingTableSent = currentTime;
                                SimpleESLProcessing.this.forceSendRoamingTable = false;
                            }
                            catch (Exception exc) {
                                logger.warn("Failed to send roaming table");
                                logger.logExceptionIfDebugEnabled((Throwable)exc);
                            }
                        }
                    }
                    logger.info("%d waiting tasks", new Object[]{SimpleESLProcessing.this.waitingTasks.size()});
                    SimpleESLProcessing.this.accessPointService.queryAssignedLabels(SimpleESLProcessing.this);
                    if (!SimpleESLProcessing.this.tasksToAbort.isEmpty()) {
                        try {
                            SimpleESLProcessing.this.abortTasks();
                        }
                        catch (WebserviceException exc) {
                            logger.warn("Unable to abort tasks: %s", new Object[]{exc.getMessage()});
                            logger.logExceptionIfDebugEnabled((Throwable)exc);
                            SimpleESLProcessing.this.tasksToAbort.clear();
                        }
                    }
                    if (SimpleESLProcessing.this.waitingTasks.size() > 0) {
                        SimpleESLProcessing.this.accessPointService.queryUpdateTasks(SimpleESLProcessing.this);
                    }
                    SimpleESLProcessing.this.processScheduledTasks();
                    try {
                        SimpleESLProcessing.this.accessPointService.sendScheduledUpdateTasks();
                    }
                    catch (Exception exc) {
                        logger.warn("Failed to send scheduled update tasks");
                        SimpleESLProcessing.this.processingSendingScheduledTaskError();
                    }
                } else {
                    logger.info("Processing stopped after %d iterations", new Object[]{SimpleESLProcessing.this.currentProcessingIteration});
                    SimpleESLProcessing.this.shutdown();
                }
            }
        });
    }

    protected void abortTasks() throws WebserviceException, SerializeException {
        for (UUID taskId : this.tasksToAbort) {
            this.accessPointService.scheduleTaskForAborting(taskId);
        }
        this.accessPointService.sendScheduledAbortRequests();
    }

    @Override
    public void processServiceStatus(AccessPointService accessPointService, AccessPointServiceStatus serviceStatus) {
        if (serviceStatus.getVersion().isEqualOlder(OLD_VERSION) && accessPointService instanceof AccessPointServiceClient) {
            ((AccessPointServiceClient)accessPointService).setUseOldVersionXMLSerialization(true);
        }
        try {
            this.wirelessChannel = serviceStatus.getChannel();
        }
        catch (RuntimeException exc) {
            logger.warn("Communicating with an Access Point without channel, using default channel 0");
            this.wirelessChannel = WirelessChannel.CHANNEL_0;
        }
    }

    @Override
    public void failedToQueryAccessPoint(AccessPointService accessPointService) {
    }

    @Override
    public void processUpdateTasks(int accessPointId, Collection<UpdateTask> receivedUpdateTasks) throws DatasetException {
        for (UpdateTask receivedUpdateTask : receivedUpdateTasks) {
            Task waitingTask = this.waitingTasks.get(receivedUpdateTask.getTaskId());
            if (waitingTask == null) continue;
            this.updateWaitingTask(waitingTask, receivedUpdateTask);
        }
        try {
            this.accessPointService.sendScheduledRemoveRequests();
        }
        catch (Exception exc) {
            logger.logException((Throwable)exc);
        }
    }

    @Override
    public void processLabelEvents(int accessPointId, Collection<LabelEvent> labelEvents) {
    }

    @Override
    public void scheduleTask(Transaction transaction, Task task) {
        if (task == null) {
            logger.warn("Task is not allowed to be null");
        } else {
            this.scheduledTasks.add(new TaskQueueEntry(transaction, task));
        }
    }

    @Override
    public void scheduleAbortRequest(AbortRequest abortRequest) {
    }

    public void addTasks(Collection<? extends Task> tasks) {
        SimpleTransaction transaction = new SimpleTransaction(0L);
        for (Task task : tasks) {
            this.scheduleTask((Transaction)transaction, task);
        }
    }

    @Override
    public void shutdown() {
        this.removeWaitingTasks();
        this.runWithoutTasks = false;
        super.shutdown();
    }

    private void removeWaitingTasks() {
        if (!this.waitingTasks.isEmpty()) {
            for (UUID taskId : this.waitingTasks.keySet()) {
                this.accessPointService.scheduleTaskForRemoval(taskId);
            }
        }
        try {
            this.accessPointService.sendScheduledRemoveRequests();
        }
        catch (Exception exc) {
            logger.logException((Throwable)exc);
        }
    }

    public boolean isFinished() {
        return this.waitingTasks.isEmpty() && !this.runWithoutTasks;
    }

    @Override
    public void processTask(Transaction transaction, Task task) {
        if (task instanceof ErrorTask) {
            ErrorTask errorTask = (ErrorTask)task;
            this.processErrorTask(transaction, errorTask);
        } else if (task instanceof InternalTask) {
            InternalTask internalTask = (InternalTask)task;
            Task convertedTask = this.updateTaskFactory.convertInternalTask(internalTask);
            this.processTask(transaction, convertedTask);
        } else if (task instanceof ExecutableTask) {
            ExecutableTask executableTask = (ExecutableTask)task;
            this.processExecutableTask(transaction, executableTask);
        } else {
            ErrorTask errorTask = new ErrorTask(task, UpdateError.ERROR_CODE_UNSUPPORTED_TASK);
            this.processTask(transaction, errorTask);
        }
    }

    @Override
    public void processAbortRequest(AbortRequest abortRequest) {
    }

    protected void processExecutableTask(Transaction transaction, ExecutableTask task) {
        UUID taskId = UUID.randomUUID();
        try {
            UpdateTask updateTask = this.updateTaskFactory.createUpdateTask(task, taskId);
            this.scheduleUpdateTask(task, updateTask);
        }
        catch (UpdateCreationException exc) {
            ErrorTask errorTask = new ErrorTask(task, exc.getUpdateError());
            this.processErrorTask(transaction, errorTask);
        }
    }

    @Override
    public void processErrorTask(Transaction transaction, ErrorTask errorTask) {
        logger.error("Error code %d during processing of task for label %s", new Object[]{errorTask.getUpdateError(), errorTask.getLabelId()});
    }

    public void scheduleUpdateTask(Task task, UpdateTask updateTask) throws UpdateCreationException {
        this.waitingTasks.put(updateTask.getTaskId(), task);
        this.accessPointService.scheduleUpdateTask(updateTask);
        this.notifyUpdateTaskAdded(updateTask);
    }

    protected void notifyUpdateTaskAdded(UpdateTask updateTask) {
        for (UpdateTaskListener listener : this.updateTaskListeners) {
            listener.updateTaskAdded(updateTask);
        }
    }

    private void notifyUpdateTaskChanged(UpdateTask updateTask) {
        for (UpdateTaskListener listener : this.updateTaskListeners) {
            listener.updateTaskChanged(updateTask);
        }
    }

    protected void processScheduledTasks() {
        while (!this.scheduledTasks.isEmpty()) {
            TaskQueueEntry entry = this.scheduledTasks.poll();
            this.processTask(entry.getTransaction(), entry.getTask());
        }
    }

    protected void updateWaitingTask(Task task, UpdateTask updateTask) {
        UpdateTaskStatus status = updateTask.getStatus();
        this.notifyUpdateTaskChanged(updateTask);
        if (status.isFinished()) {
            logger.info("Task to label %s %s", new Object[]{updateTask.getAddress(), status});
            this.waitingTasks.remove(updateTask.getTaskId());
            this.accessPointService.scheduleTaskForRemoval(updateTask.getTaskId());
            if (status.isUnsuccessful() && this.allowRetries) {
                logger.info("Retrying failed task to label %s", new Object[]{updateTask.getAddress()});
                this.addTasks(Collections.singleton(task));
            }
        }
    }

    protected void processingSendingScheduledTaskError() {
        ArrayList<UUID> waitingTasksToRemove = new ArrayList<UUID>();
        for (UUID taskId : this.waitingTasks.keySet()) {
            if (!(this.waitingTasks.get(taskId) instanceof ExecutableTask)) continue;
            ExecutableTask waitingTask = (ExecutableTask)this.waitingTasks.get(taskId);
            try {
                UpdateTask updateTask = this.updateTaskFactory.createUpdateTask(waitingTask, taskId);
                updateTask.changeStatus(UpdateTaskStatus.ERROR, UpdateError.ERROR_CODE_HTTP_COMMUNICATION);
                this.notifyUpdateTaskChanged(updateTask);
                if (this.allowRetries) {
                    logger.info("Retrying failed task to label %s", new Object[]{updateTask.getAddress()});
                    this.addTasks(Collections.singleton(waitingTask));
                    continue;
                }
                waitingTasksToRemove.add(taskId);
            }
            catch (UpdateCreationException exc) {
                SimpleTransaction transaction = new SimpleTransaction(0L);
                ErrorTask errorTask = new ErrorTask(waitingTask, exc.getUpdateError());
                this.waitingTasks.remove(taskId);
                this.processErrorTask((Transaction)transaction, errorTask);
            }
        }
        for (UUID taskId : waitingTasksToRemove) {
            this.waitingTasks.remove(taskId);
        }
    }

    protected void removeAllTasksFromAccessPoint() {
        for (UUID taskId : this.waitingTasks.keySet()) {
            this.accessPointService.scheduleTaskForRemoval(taskId);
        }
        try {
            this.accessPointService.sendScheduledRemoveRequests();
        }
        catch (Exception exc) {
            logger.logException((Throwable)exc);
        }
    }

    public void setRunWithoutTasks(boolean runWithoutTasks) {
        this.runWithoutTasks = runWithoutTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLabelForSendingRoamingTable(Address address) {
        List<Address> list = this.labelAddresses;
        synchronized (list) {
            this.labelAddresses.add(address);
        }
        this.forceSendRoamingTable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabelsForSendingRoamingTable(List<Address> addresses, boolean forceSendRoamingTable) {
        List<Address> list = this.labelAddresses;
        synchronized (list) {
            this.labelAddresses.clear();
            this.labelAddresses.addAll(addresses);
        }
        this.forceSendRoamingTable = forceSendRoamingTable;
    }

    private RoamingTable createRoamingTable() {
        ArrayList<RoamingAssignment> roamingAssignments = new ArrayList<RoamingAssignment>(this.labelAddresses.size());
        for (Address address : this.labelAddresses) {
            LabelType labelType = new LabelId(address).getLabelType();
            roamingAssignments.add(new RoamingAssignment(address, null, labelType, this.accessPointService.getAccessPointId()));
        }
        Set<ChannelTableEntry> channelTable = Collections.singleton(new ChannelTableEntry(this.accessPointService.getAccessPointId(), this.wirelessChannel));
        return new RoamingTable(this.roamingValidTimeInMinutes, this.pingIntervalInMinutes, channelTable, roamingAssignments, this.sendAcceptAllLabels, Key.emptyKey());
    }

    public void registerUpdateTaskListener(UpdateTaskListener listener) {
        this.updateTaskListeners.add(listener);
    }

    public Collection<Task> getWaitingTasks() {
        return this.waitingTasks.values();
    }

    public Task getTaskForTaskId(UUID taskId) {
        return this.waitingTasks.get(taskId);
    }

    protected void removeAllLabelsFromAccessPoint() {
        try {
            this.accessPointService.sendRoamingTable(new RoamingTable());
        }
        catch (WebserviceException exc) {
            logger.warn("Failed to send empty roaming table");
        }
        catch (SerializeException exc) {
            logger.warn("Failed to send empty roaming table");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer labelCountForSendingRoamingTable() {
        int count = 0;
        List<Address> list = this.labelAddresses;
        synchronized (list) {
            count = this.labelAddresses.size();
        }
        return count;
    }

    public void setPingIntervalInMinutes(int pingIntervalInMinutes) {
        this.pingIntervalInMinutes = pingIntervalInMinutes;
    }

    public int getPingIntervalInMinutes() {
        return this.pingIntervalInMinutes;
    }

    public void setRoamingValidTimeInMinutes(int roamingValidTimeInMinutes) {
        this.roamingValidTimeInMinutes = roamingValidTimeInMinutes;
    }

    public int getRoamingValidTimeInMinutes() {
        return this.roamingValidTimeInMinutes;
    }

    public WirelessChannel getChannel() {
        return this.wirelessChannel;
    }

    public int getAccessPointId() {
        return this.accessPointService.getAccessPointId();
    }

    public static UpdateTask convertToUpdateTask(Task task, UUID taskId, UpdateTaskFactory updateTaskFactory) {
        if (task instanceof InternalTask) {
            task = updateTaskFactory.convertInternalTask((InternalTask)task);
        }
        if (task instanceof ExecutableTask) {
            try {
                return updateTaskFactory.createUpdateTask((ExecutableTask)task, taskId);
            }
            catch (UpdateCreationException exc) {
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                return new UpdateTask(taskId, task.getLabelId().toAddress(), task.getPriority()){};
            }
        }
        return new UpdateTask(taskId, task.getLabelId().toAddress(), task.getPriority()){};
    }

    protected void addTasksToAbort(Collection<UUID> taskIds) {
        this.tasksToAbort.addAll(taskIds);
    }

    public boolean hasTasksToAbort() {
        return !this.tasksToAbort.isEmpty();
    }
}

