/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing;

import at.mrdevelopment.esl.accesspoint.AccessPointReplyCallback;
import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.service.ServiceClient;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;

public class ServiceTypeChecker
implements AccessPointReplyCallback {
    static ESLLogger logger = ESLLogger.getLogger(ServiceTypeChecker.class);
    private final int[] ports = new int[]{8000, 8080};
    private static final boolean DEFAULT_IS_ACCESSPOINT = true;
    private boolean isAccessPoint = true;
    private boolean queryFinished;
    private String connectionString;
    private String serviceName;
    private ServiceAddress serviceAddress;

    public ServiceTypeChecker(String connectionString) throws InitializationException {
        this.connectionString = connectionString;
        try {
            this.serviceAddress = ServiceAddress.fromString((String)connectionString);
        }
        catch (MalformedURLException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public ServiceTypeChecker(ServiceAddress serviceAddress) throws InitializationException {
        this(serviceAddress.getConnectionString());
    }

    public void checkType() throws Exception {
        block5: {
            ServiceAddress currentServiceAddress = ServiceAddress.fromString((String)this.connectionString);
            ServiceClient serviceClient = new ServiceClient(currentServiceAddress);
            try {
                this.queryServiceStatus(serviceClient, currentServiceAddress);
            }
            catch (Exception exc) {
                logger.info("Could not connect to service. Trying different port...");
                if (this.serviceName != null) break block5;
                for (int port : this.ports) {
                    currentServiceAddress = new ServiceAddress(currentServiceAddress.useSSL(), currentServiceAddress.getHost(), port, currentServiceAddress.getUsername(), currentServiceAddress.getPassword());
                    serviceClient = new ServiceClient(currentServiceAddress);
                    try {
                        this.queryServiceStatus(serviceClient, currentServiceAddress);
                    }
                    catch (Exception exc2) {
                        logger.info("Could not connect to service with port %d", new Object[]{port});
                    }
                }
            }
        }
        this.queryFinished = true;
    }

    private void queryServiceStatus(ServiceClient serviceClient, ServiceAddress serviceAddress) throws WebserviceException, SerializeException, IOException {
        if (this.serviceName == null) {
            serviceClient.setCredentials(serviceAddress.hasCredentials() ? serviceAddress.getUsername() : "admin", serviceAddress.hasCredentials() ? serviceAddress.getPassword() : "admin");
            serviceClient.queryServiceStatus();
            this.receivedServiceStatus(serviceClient.getServiceStatus());
            this.serviceAddress = serviceAddress;
        }
    }

    public ServiceAddress getServiceAddress() {
        return this.serviceAddress;
    }

    public boolean isAccessPoint() {
        return this.isAccessPoint;
    }

    public boolean isQueryFinished() {
        return this.queryFinished;
    }

    @Override
    public void processServiceStatus(AccessPointService accessPointService, AccessPointServiceStatus serviceStatus) {
        this.receivedServiceStatus(serviceStatus.getServiceStatus());
    }

    private void receivedServiceStatus(ServiceStatus serviceStatus) {
        if (serviceStatus != null) {
            this.serviceName = serviceStatus.getServiceName();
            if (this.serviceName.equals("Access Point")) {
                this.isAccessPoint = true;
            } else if (this.serviceName.equals("ESL Service")) {
                this.isAccessPoint = false;
            }
        }
    }

    @Override
    public void processWakeupStatistics(Collection<WakeupStatistic> receivedWakeupStatistics) {
    }

    @Override
    public void processJoinRequests(Collection<JoinRequest> joinRequests) {
    }

    @Override
    public void failedToQueryAccessPoint(AccessPointService accessPointService) {
        this.isAccessPoint = false;
    }

    @Override
    public void processUpdateTasks(int accessPointId, Collection<UpdateTask> receivedUpdateTasks) throws DatasetException {
    }

    @Override
    public void processLabelEvents(int accessPointId, Collection<LabelEvent> labelEvents) {
    }
}

