/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.persistence.record.TaskRecord;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ESL_UPDATE_IMAGE")
public class UpdateImage
implements Serializable {
    public static final String ID = "ID";
    public static final String IMAGE = "IMAGE";
    private Long id;
    private byte[] image;
    private List<TaskRecord> taskRecords = new ArrayList<TaskRecord>(0);

    public UpdateImage() {
    }

    public UpdateImage(byte[] image) {
        this.image = image;
    }

    public UpdateImage(BufferedImage image) throws SerializeException {
        this.image = ImageSerializer.toBase64((BufferedImage)image);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="IMAGE", length=48000, nullable=true)
    @Lob
    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    @OneToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @JoinColumn(name="ESL_UPDATE_IMAGE_ID")
    public List<TaskRecord> getTaskRecords() {
        return this.taskRecords;
    }

    public void setTaskRecords(List<TaskRecord> taskRecords) {
        this.taskRecords = taskRecords;
    }

    @Transient
    public BufferedImage getBufferedImage() throws SerializeException {
        return ImageSerializer.fromBase64((byte[])this.image);
    }
}

