/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.persistence.record.TaskRecord;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.type.Transaction;
import at.mrdevelopment.toolkit.authentication.Role;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="ESL_TRANSACTION")
public class TransactionRecord
extends Record
implements Transaction {
    public static final String TITLE = "TITLE";
    public static final String TASK_COUNT = "TASK_COUNT";
    public static final String EXTERNAL_ID = "EXTERNAL_ID";
    private String title;
    private Integer taskCount;
    private Long externalId;
    private List<TaskRecord> taskRecords = new ArrayList<TaskRecord>(0);

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        return UpdateStatus.getDatasetPermissions();
    }

    public TransactionRecord() {
    }

    public TransactionRecord(String tite, Integer taskCount, Long externalId) {
        this.title = tite;
        this.taskCount = taskCount;
        this.externalId = externalId;
    }

    @Column(name="TITLE", nullable=true)
    @Displayable(name="Title", width=4, order=1)
    @Serialize
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name="TASK_COUNT", nullable=true)
    @Displayable(name="Tasks", width=1, order=2)
    @Serialize
    public Integer getTaskCount() {
        return this.taskCount;
    }

    public void setTaskCount(Integer taskCount) {
        this.taskCount = taskCount;
    }

    @Column(name="EXTERNAL_ID", nullable=true)
    @Displayable(name="External ID", width=1, order=3)
    @Serialize
    public Long getExternalId() {
        return this.externalId;
    }

    public void setExternalId(Long externalId) {
        this.externalId = externalId;
    }

    @OneToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @JoinColumn(name="ESL_TRANSACTION_ID")
    public List<TaskRecord> getTaskRecords() {
        return this.taskRecords;
    }

    public void setTaskRecords(List<TaskRecord> taskRecords) {
        this.taskRecords = taskRecords;
    }

    @Override
    public void validate() throws Exception {
    }
}

