/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.BaseRecord;
import at.mrdevelopment.toolkit.authentication.Role;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;

public class Template
extends BaseRecord {
    public static final String PATTERN = ".+\\.xsl";
    private Long id;
    private String templateFilename;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public static SortedSet<String> toStrings(Collection<Template> templates) {
        return Sets.newTreeSet((Iterable)Iterables.transform(templates, (Function)new Function<Template, String>(){

            public String apply(Template template) {
                return template.getName();
            }
        }));
    }

    public Template() {
    }

    public Template(long id, String templateFilename) {
        this.id = id;
        this.templateFilename = templateFilename;
    }

    @Displayable(name="Template file", width=5)
    @Serialize
    public String getTemplateFilename() {
        return this.templateFilename;
    }

    public void setTemplateFilename(String templateFilename) {
        this.templateFilename = templateFilename;
    }

    @Serialize
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Serialize
    public String getIdentifier() {
        return this.templateFilename;
    }

    public String getName() {
        return this.templateFilename;
    }
}

