/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryDeletePermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.annotation.UserType;
import at.mrdevelopment.esl.persistence.record.LabelIdRecord;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.persistence.record.TransactionRecord;
import at.mrdevelopment.esl.persistence.record.UpdateImage;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.tasks.ErrorTask;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;

@Entity
@Table(name="ESL_TASK")
public class TaskRecord
extends Record
implements LabelIdRecord {
    public static final String LABEL_SERIAL = "LABEL_SERIAL";
    public static final String TASK_TYPE = "TASK_TYPE";
    public static final String PRIORITY = "PRIORITY";
    public static final String EXTERNAL_ID = "EXTERNAL_ID";
    public static final String PAGE = "PAGE";
    public static final String DATA = "DATA";
    public static final String TRANSACTION_ID = "ESL_TRANSACTION_ID";
    public static final String UPDATE_IMAGE_ID = "ESL_UPDATE_IMAGE_ID";
    private Long label;
    private TaskType taskType;
    private TaskPriority priority;
    private Long externalId;
    private Integer page;
    private TransactionRecord transaction;
    private String data;
    private UpdateImage updateImage;
    private List<UpdateStatus> updateStatusList = new ArrayList<UpdateStatus>(0);

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryDeletePermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public TaskRecord() {
    }

    public TaskRecord(TransactionRecord transaction, ExecutableTask task, int retries) throws SerializeException {
        this(transaction, (Task)task, retries);
        this.taskType = task.getTaskType();
    }

    public TaskRecord(TransactionRecord transaction, ErrorTask task) throws SerializeException {
        this(transaction, task, 0);
        this.taskType = task.getTaskType();
    }

    private TaskRecord(TransactionRecord transaction, Task task, int retries) throws SerializeException {
        this.transaction = transaction;
        this.label = task.getLabelId().getId();
        this.priority = task.getPriority();
        this.externalId = task.getExternalId();
        this.page = task.getPage() != null ? Integer.valueOf(task.getPage().getPageIndex()) : null;
        this.data = task.getData();
        this.updateImage = task.getImage() != null ? new UpdateImage(task.getImage()) : null;
    }

    @Column(name="LABEL_SERIAL", nullable=false)
    @Index(name="IDX_LABEL_SERIAL")
    @Displayable(name="Label ID", width=4, order=1)
    @UserType(value=LabelId.class)
    @Serialize
    public Long getLabel() {
        return this.label;
    }

    public void setLabel(Long label) {
        this.label = label;
    }

    @Column(name="TASK_TYPE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @Displayable(name="Task Type", width=3, order=4)
    @Serialize
    public TaskType getTaskType() {
        return this.taskType;
    }

    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    @Column(name="PRIORITY", nullable=false)
    @Displayable(name="Priority", width=3, filter=false, order=3)
    @Serialize
    public TaskPriority getPriority() {
        return this.priority;
    }

    public void setPriority(TaskPriority priority) {
        this.priority = priority;
    }

    @Column(name="EXTERNAL_ID", nullable=true)
    @Displayable(name="External ID", width=1, filter=false, order=2)
    @Serialize
    public Long getExternalId() {
        return this.externalId;
    }

    public void setExternalId(Long externalId) {
        this.externalId = externalId;
    }

    @Column(name="PAGE", nullable=true)
    @Displayable(name="Page", width=1, filter=false, order=5)
    @UserType(value=Page.class)
    @Serialize
    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ESL_TRANSACTION_ID")
    public TransactionRecord getTransaction() {
        return this.transaction;
    }

    public void setTransaction(TransactionRecord transaction) {
        this.transaction = transaction;
    }

    @Column(name="DATA", nullable=true)
    @UserType(value=Page.class)
    @Serialize
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ESL_UPDATE_IMAGE_ID")
    public UpdateImage getUpdateImage() {
        return this.updateImage;
    }

    public void setUpdateImage(UpdateImage updateImage) {
        this.updateImage = updateImage;
    }

    @OneToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @JoinColumn(name="ESL_TASK_ID")
    public List<UpdateStatus> getUpdateStatusList() {
        return this.updateStatusList;
    }

    public void setUpdateStatusList(List<UpdateStatus> updateStatusList) {
        this.updateStatusList = updateStatusList;
    }

    @Transient
    public boolean hasExternalId() {
        return this.externalId != null;
    }

    @Transient
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    @Transient
    public LabelId getLabelId() {
        return new LabelId(this.label);
    }

    @Override
    @Transient
    @Serialize
    public String getLabelIdString() {
        return this.getLabelId().getLabelIdString();
    }

    @Override
    @Transient
    public String getName() {
        return new LabelId(this.label).toString();
    }

    @Transient
    @Serialize
    public Long getTransactionId() {
        return this.transaction != null ? this.transaction.getId() : null;
    }

    @Override
    public void validate() {
    }
}

