/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Editable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.annotation.UserType;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.wireless.Address;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ESL_REGISTERED_LABEL")
public class RegisteredLabel
extends Record {
    public static final String LABEL_ID = "LABEL_SERIAL";
    public static final String PIN = "PIN";
    public static final String TAG = "TAG";
    private Long label;
    private Long pinCode;
    private Set<String> tags = new HashSet<String>();

    public RegisteredLabel() {
    }

    public RegisteredLabel(LabelId labelId, Pin pin, Set<String> tags) {
        this.label = labelId.getId();
        this.pinCode = pin != null ? Long.valueOf(pin.toLong()) : null;
        this.tags.addAll(tags);
    }

    @Column(name="LABEL_SERIAL", nullable=false, unique=true)
    @UserType(value=LabelId.class)
    public Long getLabel() {
        return this.label;
    }

    public void setLabel(Long label) {
        this.label = label;
    }

    @Column(name="PIN", nullable=true)
    public Long getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(Long pinCode) {
        this.pinCode = pinCode;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="ESL_LABEL_TAG", joinColumns={@JoinColumn(name="LABEL_SERIAL")})
    @Column(name="TAG")
    @Displayable(name="Tags", width=4, order=5)
    @Editable
    @Serialize(collectionType=String.class)
    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public void addTags(Set<String> tags) {
        this.tags = tags;
    }

    public Address toAddress() {
        return Address.fromId((long)this.label);
    }

    public LabelId toLabelId() {
        return new LabelId(this.label);
    }

    public LabelRegistration toLabelRegistration() {
        return new LabelRegistration(this.toLabelId(), this.getPin(), this.getTags());
    }

    @Transient
    public Pin getPin() {
        return this.pinCode != null ? Pin.fromLong((long)this.pinCode) : null;
    }

    public void setPin(Pin pin) {
        this.pinCode = pin.toLong();
    }

    public boolean hasPin() {
        return this.pinCode != null;
    }

    public void removePin() {
        this.pinCode = null;
    }

    @Override
    public void validate() throws Exception {
    }
}

