/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.BaseRecord;
import at.mrdevelopment.esl.persistence.record.User;
import at.mrdevelopment.toolkit.authentication.UserId;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@MappedSuperclass
public abstract class Record
extends BaseRecord {
    public static final String ID = "ID";
    public static final String REVISION = "REVISION";
    public static final String CREATED_AT = "CREATED_AT";
    public static final String UPDATED_AT = "UPDATED_AT";
    public static final String LAST_MODIFIED_BY_USER_ID = "ESL_USER_ID";
    private Long id = null;
    private Integer revision = 0;
    private DateTime createdAt = null;
    private DateTime updatedAt = null;
    private User lastModifiedBy;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    @Serialize
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="REVISION", nullable=false)
    @Serialize
    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    @Column(name="CREATED_AT", nullable=false)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Serialize
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Column(name="UPDATED_AT", nullable=false)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Displayable(name="Updated At", width=4, filter=false, order=100, ignoreOnRecursion=true)
    @Serialize
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @JoinColumn(name="ESL_USER_ID")
    public User getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(User lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public abstract void validate() throws Exception;

    @Transient
    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    @Transient
    public boolean isNewRecord() {
        return this.id == null;
    }

    public void onCreate(UserId user) {
        this.revision = 0;
        this.updatedAt = this.createdAt = new DateTime();
        this.lastModifiedBy = this.toUser(user);
    }

    public void onUpdate(UserId user) {
        this.updatedAt = new DateTime();
        this.revision = this.revision + 1;
        this.lastModifiedBy = this.toUser(user);
    }

    public void onDelete(UserId user) {
        this.updatedAt = new DateTime();
        this.revision = this.revision + 1;
        this.lastModifiedBy = this.toUser(user);
    }

    @Transient
    public String getName() {
        return this.getIdentifier();
    }

    @Transient
    public String getIdentifier() {
        return this.id == null ? "New" : Long.toString(this.id);
    }

    public String toString() {
        return String.format("%s : ID %d : Revision %d", ((Object)((Object)this)).getClass().getSimpleName(), this.id, this.revision);
    }

    private User toUser(UserId userId) {
        if (userId instanceof User) {
            return (User)userId;
        }
        return null;
    }
}

