/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryInsertDeletePermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.DefaultLabelTypeMapping;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SecurityStatus;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.core.SyncQuality;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Editable;
import at.mrdevelopment.esl.persistence.annotation.IncludeDisplayables;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.annotation.UserType;
import at.mrdevelopment.esl.persistence.record.BaseRecord;
import at.mrdevelopment.esl.persistence.record.LabelIdRecord;
import at.mrdevelopment.esl.persistence.record.UpdateRecord;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.esl.type.UpdateInfo;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.authentication.Role;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class LabelInfo
extends BaseRecord
implements LabelIdRecord,
UpdateRecord,
Comparable<LabelInfo> {
    private Long label;
    private Long pinCode;
    private String type;
    private Set<String> tags = new TreeSet<String>();
    private DateTime wakeupTime;
    private Version firmwareVersion;
    private SecurityStatus securityStatus;
    private PowerStatus powerStatus;
    private SyncQuality syncQuality;
    private LabelErrors labelErrors;
    private Page currentPage;
    private Integer rssi;
    private Integer lqi;
    private Integer accessPointId;
    private ConnectionStatus connectionStatus;
    private UpdateInfo updateInfo;
    private DateTime lastRefreshTime;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryInsertDeletePermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public static List<LabelId> toLabelIdList(Collection<LabelInfo> labelInfos) {
        return Lists.newArrayList((Iterable)Collections2.transform(labelInfos, (Function)new Function<LabelInfo, LabelId>(){

            public LabelId apply(LabelInfo labelInfo) {
                return labelInfo.toLabelId();
            }
        }));
    }

    public static List<LabelRegistration> toLabelRegistrationList(Collection<LabelInfo> labelInfos) {
        return Lists.newArrayList((Iterable)Collections2.transform(labelInfos, (Function)new Function<LabelInfo, LabelRegistration>(){

            public LabelRegistration apply(LabelInfo labelInfo) {
                return labelInfo.toLabelRegistration();
            }
        }));
    }

    public LabelInfo() {
        this.connectionStatus = ConnectionStatus.OFFLINE;
        this.updateInfo = new UpdateInfo();
    }

    public LabelInfo(LabelId labelId, Pin pin, Set<String> tags) {
        this.label = labelId.getId();
        this.pinCode = pin != null ? Long.valueOf(pin.toLong()) : null;
        this.tags.addAll(tags);
        this.type = DefaultLabelTypeMapping.getType(this.label).getName();
        this.securityStatus = SecurityStatus.UNKNOWN;
        this.connectionStatus = ConnectionStatus.OFFLINE;
        this.updateInfo = new UpdateInfo();
    }

    @Displayable(name="Label ID", width=3, order=1)
    @UserType(value=LabelId.class)
    @Editable
    @Serialize
    public Long getLabel() {
        return this.label;
    }

    public void setLabel(Long label) {
        this.label = label;
    }

    @Serialize
    public Long getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(Long pinCode) {
        this.pinCode = pinCode;
    }

    @Displayable(name="Type", width=1, filter=false, order=2)
    @Serialize
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Displayable(name="Tags", width=3, order=3)
    @Serialize(collectionType=String.class)
    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags.clear();
        this.tags.addAll(tags);
    }

    public void addTags(Set<String> tags) {
        this.tags.addAll(tags);
    }

    @Displayable(name="Last Seen", width=3, filter=false, order=4)
    @Serialize
    public DateTime getWakeupTime() {
        return this.wakeupTime;
    }

    public void setWakeupTime(DateTime wakeupTime) {
        this.wakeupTime = wakeupTime;
    }

    @Displayable(name="Power", width=1, filter=true, order=5)
    @Serialize
    public PowerStatus getPowerStatus() {
        return this.powerStatus;
    }

    public void setPowerStatus(PowerStatus powerStatus) {
        this.powerStatus = powerStatus;
    }

    @Displayable(name="RSSI", width=1, filter=false, order=20)
    @Serialize
    public Integer getRssi() {
        return this.rssi;
    }

    public void setRssi(Integer rssi) {
        this.rssi = rssi;
    }

    @Displayable(name="LQI", width=1, filter=false, order=21)
    @Serialize
    public Integer getLqi() {
        return this.lqi;
    }

    public void setLqi(Integer lqi) {
        this.lqi = lqi;
    }

    @Displayable(name="Firmware", width=1, filter=false, order=22)
    @Serialize
    public Version getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(Version firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    @Displayable(name="Encryption", width=1, filter=false, order=23)
    @Serialize
    public SecurityStatus getSecurityStatus() {
        return this.securityStatus;
    }

    public void setSecurityStatus(SecurityStatus securityStatus) {
        this.securityStatus = securityStatus;
    }

    public boolean isEncrypted() {
        return this.securityStatus.isEncrypted();
    }

    @Displayable(name="Sync-Quality", width=1, filter=false, order=24)
    @Serialize
    public SyncQuality getSyncQuality() {
        return this.syncQuality;
    }

    public void setSyncQuality(SyncQuality syncQuality) {
        this.syncQuality = syncQuality;
    }

    @Displayable(name="Label Error", width=1, filter=false, order=25)
    @Serialize
    public LabelErrors getLabelErrors() {
        return this.labelErrors;
    }

    public void setLabelErrors(LabelErrors labelErrors) {
        this.labelErrors = labelErrors;
    }

    @Serialize
    public Page getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(Page currentPage) {
        this.currentPage = currentPage;
    }

    @Displayable(name="AP ID", width=1, filter=true, order=26)
    @Serialize
    public Integer getAccessPointId() {
        return this.accessPointId;
    }

    public void setAccessPointId(Integer accessPointId) {
        this.accessPointId = accessPointId;
    }

    @Displayable(name="Label Status", width=2, filter=true, order=90)
    @Serialize
    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public boolean isOnline() {
        return this.connectionStatus.isOnline();
    }

    @IncludeDisplayables
    @Serialize(recursive=true)
    public UpdateInfo getUpdateInfo() {
        return this.updateInfo;
    }

    public void setUpdateInfo(UpdateInfo updateInfo) {
        this.updateInfo = updateInfo;
        this.updateLastRefreshTime(updateInfo);
    }

    public LabelId toLabelId() {
        return new LabelId(this.label);
    }

    public LabelRegistration toLabelRegistration() {
        return new LabelRegistration(new LabelId(this.label), this.getPin(), this.tags);
    }

    public Address toAddress() {
        return Address.fromId((long)this.label);
    }

    @Serialize
    public Long getId() {
        return this.label;
    }

    public void setId(Long id) {
        this.label = id;
    }

    public String getIdentifier() {
        return this.toLabelId().getLabelIdString();
    }

    public String getName() {
        return this.toLabelId().toString();
    }

    @Override
    public LabelId getLabelId() {
        return this.toLabelId();
    }

    public Pin getPin() {
        return this.pinCode != null ? Pin.fromLong((long)this.pinCode) : null;
    }

    public void setPin(Pin pin) {
        this.pinCode = pin.toLong();
    }

    public boolean hasPin() {
        return this.pinCode != null;
    }

    public void removePin() {
        this.pinCode = null;
    }

    @Override
    @Serialize
    public String getLabelIdString() {
        return this.getLabelId().getLabelIdString();
    }

    @Override
    public UUID getTaskId() {
        return this.updateInfo != null ? this.updateInfo.getTaskId() : null;
    }

    @Override
    public TaskType getTaskType() {
        return this.updateInfo != null ? this.updateInfo.getTaskType() : null;
    }

    @Override
    public Status getStatus() {
        return this.updateInfo != null ? this.updateInfo.getStatus() : null;
    }

    public Integer getPage() {
        return this.updateInfo != null ? this.updateInfo.getPage() : null;
    }

    public Integer getUpdateErrorCode() {
        return this.updateInfo != null ? this.updateInfo.getErrorCode() : null;
    }

    public DateTime getLastUpdateTime() {
        return this.updateInfo != null ? this.updateInfo.getUpdatedAt() : null;
    }

    @Serialize
    public DateTime getLastRefreshTime() {
        return this.lastRefreshTime;
    }

    public void setLastRefreshTime(DateTime lastRefreshTime) {
        this.lastRefreshTime = lastRefreshTime;
    }

    private void updateLastRefreshTime(UpdateInfo updateInfo) {
        if (this.lastRefreshTime == null || updateInfo.getTaskType().isDisplayUpdate() && updateInfo.getStatus().isSuccessful() && this.lastRefreshTime.isBefore((ReadableInstant)updateInfo.getUpdatedAt())) {
            this.lastRefreshTime = updateInfo.getUpdatedAt();
        }
    }

    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public int compareTo(LabelInfo other) {
        return this.label.compareTo(other.label);
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof LabelInfo)) {
            return false;
        }
        return this.label.equals(((LabelInfo)other).label);
    }
}

