/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.persistence.annotation.CustomField;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Editable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.annotation.UserType;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.Gtin;
import at.mrdevelopment.toolkit.Money;
import at.mrdevelopment.toolkit.authentication.Role;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ESL_ARTICLE")
public class ArticleRecord
extends Record {
    public static final String NAME = "NAME";
    public static final String ARTICLE_NUMBER = "ARTICLE_NUMBER";
    public static final String PRICE = "PRICE";
    public static final String ARTICLE_RECORD_ID = "ESL_ARTICLE_ID";
    public static final String CUSTOM_FIELDS_KEY = "FIELD_KEY";
    public static final String CUSTOM_FIELDS_VALUE = "FIELD_VALUE";
    public static final String GTIN = "GTIN";
    private String name;
    private String articleNumber;
    private String price;
    private Set<Long> gtins = new HashSet<Long>();
    private Map<String, String> customFields = new HashMap<String, String>();

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.USER, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public static ArticleRecord fromArticle(Article article) {
        HashSet<Long> gtins = new HashSet<Long>();
        for (Gtin gtin : article.getGtins()) {
            gtins.add(gtin.toLong());
        }
        HashMap<String, String> values = new HashMap<String, String>(article.getValues());
        String articleNumber = article.getArticleNumber().toString();
        String name = (String)values.remove("name");
        String price = (String)values.remove("price");
        return new ArticleRecord(name, articleNumber, price, gtins, values);
    }

    public static Iterable<ArticleRecord> fromArticles(Iterable<Article> articles) {
        return Iterables.transform(articles, (Function)new Function<Article, ArticleRecord>(){

            public ArticleRecord apply(Article article) {
                return ArticleRecord.fromArticle(article);
            }
        });
    }

    public ArticleRecord() {
    }

    public ArticleRecord(String name, String articleNumber, String price, Set<Long> gtins, Map<String, String> customFields) {
        this.name = name;
        this.articleNumber = articleNumber;
        this.price = price;
        this.gtins = gtins;
        this.customFields = customFields;
    }

    @Override
    @Column(name="NAME", nullable=false)
    @Displayable(name="Name", width=5, order=1)
    @Editable
    @Serialize
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="ARTICLE_NUMBER", nullable=false, unique=true)
    @Displayable(name="Article Number", width=4, order=3)
    @Editable
    @Serialize
    public String getArticleNumber() {
        return this.articleNumber;
    }

    public void setArticleNumber(String articleNumber) {
        this.articleNumber = articleNumber;
    }

    @Column(name="PRICE", nullable=false)
    @Displayable(name="Price", width=2, order=4)
    @UserType(value=Money.class)
    @Editable
    @Serialize
    public String getPrice() {
        return this.price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="ESL_ARTICLE_GTIN", joinColumns={@JoinColumn(name="ESL_ARTICLE_ID")})
    @Column(name="GTIN")
    @Displayable(name="GTIN", width=4, order=5)
    @Editable
    @Serialize(collectionType=Long.class)
    public Set<Long> getGtins() {
        return this.gtins;
    }

    public void setGtins(Set<Long> gtins) {
        this.gtins = gtins;
    }

    @Transient
    @CustomField
    @Displayable(name="Custom", width=2, order=100)
    @Editable
    @Serialize
    public String getCustomField(String key) {
        return this.customFields.get(key);
    }

    public void setCustomField(String key, String value) {
        this.customFields.put(key, value);
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="ESL_CUSTOM_FIELDS", joinColumns={@JoinColumn(name="ESL_ARTICLE_ID")})
    @MapKeyColumn(name="FIELD_KEY")
    @Column(name="FIELD_VALUE")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @Override
    public void validate() throws Exception {
    }

    @Override
    @Transient
    public String getIdentifier() {
        return this.articleNumber;
    }

    @Transient
    public Article toArticle() {
        HashSet<Gtin> gtins = new HashSet<Gtin>();
        for (Long gtin : this.gtins) {
            gtins.add(Gtin.fromLong((long)gtin));
        }
        HashMap<String, String> customFields = new HashMap<String, String>();
        customFields.put("name", this.name);
        customFields.put("price", this.price);
        for (Map.Entry<String, String> customField : this.customFields.entrySet()) {
            customFields.put(customField.getKey(), customField.getValue());
        }
        return new Article(ArticleNumber.fromString((String)this.articleNumber), gtins, customFields);
    }

    public boolean updateFrom(Article article) {
        if (this.toArticle().isEqual(article)) {
            return false;
        }
        HashSet<Long> gtins = new HashSet<Long>();
        for (Gtin gtin : article.getGtins()) {
            gtins.add(gtin.toLong());
        }
        HashMap<String, String> values = new HashMap<String, String>(article.getValues());
        String name = (String)values.remove("name");
        String price = (String)values.remove("price");
        this.setName(name);
        this.setPrice(price);
        this.setGtins(gtins);
        this.setCustomFields(values);
        return true;
    }
}

