/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.BaseRecord;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.authentication.Role;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

public class AccessPointInfo
extends BaseRecord {
    private String name;
    private Integer accessPointId;
    private String serial;
    private String address;
    private WirelessChannel channel;
    private ConnectionStatus connectionStatus;
    private Version version;
    private DateTime updateTime;
    private Boolean autoConfig;
    private String server;
    private AccessPointServiceStatus serviceStatus;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public static AccessPointInfo createOffline(int accessPointId, ServiceAddress serviceAddress) {
        return new AccessPointInfo(accessPointId, serviceAddress, ConnectionStatus.OFFLINE, null, DateTime.now(), null);
    }

    public static AccessPointInfo createDiscovered(int accessPointId, ServiceAddress serviceAddress, Version version, boolean autoConfig) {
        return new AccessPointInfo(accessPointId, serviceAddress, ConnectionStatus.DISCOVERED, version, DateTime.now(), autoConfig);
    }

    public AccessPointInfo() {
    }

    private AccessPointInfo(int accessPointId, ServiceAddress serviceAddress, ConnectionStatus connectionStatus, Version version, DateTime updateTime, Boolean autoConfig) {
        this.accessPointId = accessPointId;
        this.name = null;
        this.address = serviceAddress.toString();
        this.connectionStatus = connectionStatus;
        this.version = version;
        this.updateTime = updateTime;
        this.autoConfig = autoConfig;
    }

    @Serialize
    public Long getId() {
        return (long)this.accessPointId;
    }

    public void setId(Long id) {
        this.accessPointId = id.intValue();
    }

    public String getIdentifier() {
        return this.name;
    }

    @Displayable(name="AP ID", width=2, order=1)
    @Serialize
    public Integer getAccessPointId() {
        return this.accessPointId;
    }

    public void setAccessPointId(Integer accessPointId) {
        this.accessPointId = accessPointId;
    }

    @Displayable(name="Hostname", width=4, order=2)
    @Serialize
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Displayable(name="Serial", width=4, order=3)
    @Serialize
    public String getSerial() {
        return this.serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    @Serialize
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Displayable(name="Server", width=4, order=4)
    @Serialize
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    @Displayable(name="Channel", width=2, filter=false, order=5)
    @Serialize
    public WirelessChannel getChannel() {
        return this.channel;
    }

    public void setChannel(WirelessChannel channel) {
        this.channel = channel;
    }

    @Displayable(name="Status", width=4, order=90)
    @Serialize
    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public boolean isOnline() {
        return this.connectionStatus.isOnline();
    }

    public boolean isOffline() {
        return this.connectionStatus.isOffline();
    }

    public boolean isDiscovered() {
        return this.connectionStatus.isDiscovered();
    }

    @Displayable(name="Auto Config", width=2, filter=false, order=10)
    @Serialize
    public Boolean getAutoConfig() {
        return this.autoConfig;
    }

    public void setAutoConfig(Boolean autoConfig) {
        this.autoConfig = autoConfig;
    }

    @Displayable(name="Version", width=2, filter=false, order=11)
    @Serialize
    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @Displayable(name="Last Update", width=4, filter=false, order=12)
    @Serialize
    public DateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(DateTime updateTime) {
        this.updateTime = updateTime;
    }

    public AccessPointServiceStatus getServiceStatus() {
        return this.serviceStatus;
    }

    public void setServiceStatus(AccessPointServiceStatus serviceStatus) {
        this.serviceStatus = serviceStatus;
        if (serviceStatus != null) {
            this.name = serviceStatus.getHostname();
            this.serial = serviceStatus.getSerial();
            this.channel = serviceStatus.getChannel();
            this.server = serviceStatus.getServer();
            this.autoConfig = serviceStatus.isAutoConfig();
            this.version = serviceStatus.getVersion();
            this.updateTime = DateTime.now();
        }
    }
}

