/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.AccessPointRegistration;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.gui.editor.HostEditor;
import at.mrdevelopment.esl.gui.editor.HostnameEditor;
import at.mrdevelopment.esl.gui.editor.IPAddressEditor;
import at.mrdevelopment.esl.gui.editor.NetmaskEditor;
import at.mrdevelopment.esl.gui.editor.PortEditor;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Editable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.KeepDeletedRecord;
import at.mrdevelopment.toolkit.authentication.Role;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ESL_AP_CONFIGURATION")
public class AccessPointConfiguration
extends KeepDeletedRecord {
    public static final String AP_ID = "AP_ID";
    public static final String HOSTNAME = "HOSTNAME";
    public static final String ADDRESS = "ADDRESS";
    public static final String SUBNETMASK = "SUBNETMASK";
    public static final String GATEWAY = "GATEWAY";
    public static final String DNS = "DNS";
    public static final String CHANNEL = "CHANNEL";
    public static final String PORT = "PORT";
    public static final String SSL = "USE_SSL";
    private Integer accessPointId;
    private String hostName;
    private String address;
    private String subnetMask;
    private String gateway;
    private String dns;
    private Integer port = 8080;
    private Boolean ssl = false;
    private WirelessChannel channel;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public static AccessPointConfiguration fromAccessPointRegistration(AccessPointRegistration registration) {
        AccessPointConfiguration configuration = new AccessPointConfiguration();
        configuration.accessPointId = registration.getAccessPointId();
        configuration.address = registration.getServiceAddress().getHost();
        configuration.port = registration.getServiceAddress().getPort();
        configuration.ssl = registration.getServiceAddress().useSSL();
        AccessPointRegistration.Configuration registrationConfiguration = registration.getConfiguration();
        configuration.updateConfiguration(registrationConfiguration);
        return configuration;
    }

    @Column(name="AP_ID", nullable=false)
    @Displayable(name="AP ID", width=3, order=1)
    @Editable(createOnly=true)
    @Serialize
    public Integer getAccessPointId() {
        return this.accessPointId;
    }

    public void setAccessPointId(Integer accessPointId) {
        this.accessPointId = accessPointId;
    }

    @Column(name="ADDRESS", nullable=false)
    @Displayable(name="Host", width=3, order=2)
    @Editable(editor=HostEditor.class)
    @Serialize
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name="PORT", nullable=false)
    @Displayable(name="Port", width=3, order=3)
    @Editable(editor=PortEditor.class)
    @Serialize
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    @Column(name="USE_SSL", nullable=false)
    @Editable
    @Serialize
    public Boolean getSsl() {
        return this.ssl;
    }

    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }

    @Column(name="HOSTNAME", nullable=true)
    @Displayable(name="Host Name", width=3, order=50)
    @Editable(editor=HostnameEditor.class)
    @Serialize
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Column(name="SUBNETMASK", nullable=true)
    @Displayable(name="Subnet Mask", width=3, order=51)
    @Editable(editor=NetmaskEditor.class)
    @Serialize
    public String getSubnetMask() {
        return this.subnetMask;
    }

    public void setSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
    }

    @Column(name="GATEWAY", nullable=true)
    @Displayable(name="Gateway", width=3, order=52)
    @Editable(editor=IPAddressEditor.class)
    @Serialize
    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    @Column(name="DNS", nullable=true)
    @Displayable(name="DNS", width=3, order=53)
    @Editable(editor=IPAddressEditor.class)
    @Serialize
    public String getDns() {
        return this.dns;
    }

    public void setDns(String dns) {
        this.dns = dns;
    }

    @Column(name="CHANNEL", nullable=true)
    @Displayable(name="Channel", width=3, order=54)
    @Editable
    @Serialize
    public WirelessChannel getChannel() {
        return this.channel;
    }

    public void setChannel(WirelessChannel channel) {
        this.channel = channel;
    }

    @Transient
    public boolean isAutoConfig() {
        return this.hostName != null && !this.hostName.isEmpty();
    }

    @Transient
    public ServiceAddress getServiceAddress() {
        return this.address != null ? new ServiceAddress(this.ssl.booleanValue(), this.address, this.port.intValue()) : null;
    }

    @Transient
    public boolean updateConfiguration(AccessPointRegistration.Configuration registrationConfiguration) {
        if (registrationConfiguration.isValid()) {
            this.hostName = registrationConfiguration.getHostName();
            this.address = registrationConfiguration.getStaticIpAddress();
            this.subnetMask = registrationConfiguration.getSubnetMask();
            this.gateway = registrationConfiguration.getGateway();
            this.dns = registrationConfiguration.getDns();
            this.channel = registrationConfiguration.getChannel();
            return true;
        }
        return false;
    }

    @Override
    public void validate() throws Exception {
    }
}

