/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.RecordUtils;
import at.mrdevelopment.esl.persistence.RecordXMLSerializer;
import at.mrdevelopment.esl.persistence.dataset.WebserviceDataset;
import at.mrdevelopment.esl.persistence.record.Commit;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.Id;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.http.HttpServiceClient;
import at.mrdevelopment.toolkit.http.ResponseHandler;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.EntityTemplate;
import org.w3c.dom.Document;

public class WebserviceFullDataset<T extends Commitable>
extends WebserviceDataset<T> {
    private final RecordXMLSerializer<Id> idSerializer = new RecordXMLSerializer<Id>(Id.class);
    private final RecordXMLSerializer<Commit> commitSerializer = new RecordXMLSerializer<Commit>(Commit.class);
    private final XMLContentProducerFactory contentProducerFactory = XMLContentProducerFactory.newInstance();

    public WebserviceFullDataset(HttpServiceClient httpServiceClient, Class<T> recordClass, Map<Role, DatasetPermissions> datasetPermissions, List<String> customFields) throws InitializationException {
        super(httpServiceClient, recordClass, datasetPermissions, customFields);
    }

    @Override
    public void store(T record, UserId user) throws DatasetException {
        this.store((Collection<T>)Collections.singleton(record), user);
    }

    @Override
    public void delete(T record, UserId user) throws DatasetException {
        this.delete((Collection<T>)Collections.singleton(record), user);
    }

    @Override
    public void store(final Collection<T> records, UserId user) throws DatasetException {
        this.checkStorePermission(user.getRole());
        RecordUtils.setTransmissionIds(records);
        HttpPost request = new HttpPost(this.getStoreUrl());
        try {
            Document document = this.recordSerializer.toXML(records);
            request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        }
        catch (SerializeException exc) {
            throw new DatasetException((Throwable)exc);
        }
        this.httpServiceClient.executeRequestAsync((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Void>(){

            public Void handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                List commits = WebserviceFullDataset.this.commitSerializer.parseXML(inputStream);
                for (Commit commit : commits) {
                    WebserviceDataset.logger.info(commit.toString());
                }
                RecordUtils.applyCommits(commits, (Collection)records);
                WebserviceFullDataset.this.recordsModified(records);
                return null;
            }
        });
    }

    @Override
    public void delete(final Collection<T> records, UserId user) throws DatasetException {
        this.checkDeletePermission(user.getRole());
        RecordUtils.setTransmissionIds(records);
        HttpPost request = new HttpPost(this.getDeleteUrl());
        try {
            Document document = this.idSerializer.toXML(RecordUtils.toIds(records));
            request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        }
        catch (SerializeException exc) {
            throw new DatasetException((Throwable)exc);
        }
        this.httpServiceClient.executeRequestAsync((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Void>(){

            public Void handleResponse(HttpResponse response) throws Exception {
                List commits = WebserviceFullDataset.this.commitSerializer.parseXML(response.getEntity().getContent());
                RecordUtils.applyCommits(commits, (Collection)records);
                WebserviceFullDataset.this.recordsModified(records);
                return null;
            }
        });
    }

    private String getStoreUrl() {
        return this.getServiceUrl() + "/store.xml";
    }

    private String getDeleteUrl() {
        return this.getServiceUrl() + "/delete.xml";
    }
}

