/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.IndexedDataset;
import at.mrdevelopment.esl.persistence.record.AbstractDataset;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.toolkit.Abortable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.UserId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ListDataset<T extends Commitable>
extends AbstractDataset<T>
implements IndexedDataset<T> {
    private final List<T> records = new ArrayList<T>(0);

    public ListDataset(Class<T> recordClass) throws InitializationException {
        super(recordClass, DatasetPermissions.QUERY_PERMISSIONS);
    }

    public T queryById(long id) throws DatasetException {
        throw new DatasetException("Query by ID not implemented", new Object[0]);
    }

    public T getRecordById(long id) {
        throw new RuntimeException("Fetch by ID not implemented");
    }

    public List<T> queryAll() throws DatasetException {
        return Collections.unmodifiableList(this.records);
    }

    @Override
    public void store(Collection<T> records, UserId user) throws DatasetException {
        this.records.addAll(records);
        this.notifyRecordsModified(records);
    }

    @Override
    public void delete(Collection<T> records, UserId user) throws DatasetException {
        throw new DatasetException("Delete not implemented", new Object[0]);
    }

    public Abortable reload() throws DatasetException {
        return Abortable.DO_NOTHING;
    }

    public void close() {
        this.records.clear();
    }

    public T getRecord(int index) {
        return (T)((Commitable)this.records.get(index));
    }

    public int getRecordCount() {
        return this.records.size();
    }
}

