/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence;

import at.mrdevelopment.esl.persistence.DatasetModifiedListener;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.record.CommitState;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.toolkit.userinfo.UserInfo;
import java.util.Collection;

public class DatasetModifiedNotification<T extends Commitable>
implements DatasetModifiedListener<T> {
    private final UserInfo userInfo;
    private final String singularName;
    private final String pluralName;

    public DatasetModifiedNotification(Dataset<T> dataset, UserInfo userInfo, String singularName, String pluralName) {
        this.userInfo = userInfo;
        this.singularName = singularName;
        this.pluralName = pluralName;
        dataset.addDatasetModifiedListener((DatasetModifiedListener)this);
    }

    public void recordsModified(Collection<T> records) {
        int insertedCount = 0;
        int updatedCount = 0;
        int deletedCount = 0;
        for (Commitable commit : records) {
            CommitState commitState = commit.getCommitState();
            String commitMessage = commit.getCommitMessage();
            if (commitState == null) continue;
            if (commitState.isInserted()) {
                ++insertedCount;
                continue;
            }
            if (commitState.isUpdated()) {
                ++updatedCount;
                continue;
            }
            if (commitState.isDeleted()) {
                ++deletedCount;
                continue;
            }
            if (!commitState.isFailed()) continue;
            this.userInfo.addError("Failed to modify %s %s: %s", new Object[]{this.singularName, commit.getName(), commitMessage});
        }
        if (insertedCount > 0) {
            this.userInfo.addInfo("%d %s inserted", new Object[]{insertedCount, insertedCount == 1 ? this.singularName : this.pluralName});
        }
        if (updatedCount > 0) {
            this.userInfo.addInfo("%d %s updated", new Object[]{updatedCount, updatedCount == 1 ? this.singularName : this.pluralName});
        }
        if (deletedCount > 0) {
            this.userInfo.addInfo("%d %s deleted", new Object[]{deletedCount, deletedCount == 1 ? this.singularName : this.pluralName});
        }
    }
}

