/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.security.UnlockCode;
import at.mrdevelopment.esl.gui.editor.TextEditor;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class UnlockCodeEditor
extends TextEditor<String> {
    private final boolean allowLabelId;
    private UnlockCode unlockCode;

    public UnlockCodeEditor() {
        this(true, false);
    }

    public UnlockCodeEditor(boolean allowLabelId, boolean canBeNull) {
        this.allowLabelId = allowLabelId;
        this.setCanBeNull(canBeNull);
    }

    public UnlockCodeEditor(int length, boolean allowLabelId, boolean canBeNull) {
        this.allowLabelId = allowLabelId;
        this.setCanBeNull(canBeNull);
    }

    public String getValue() {
        return this.getEditorText();
    }

    public UnlockCode getUnlockCode() {
        return this.unlockCode;
    }

    public void validate() {
        super.validate();
        String value = this.getEditorText();
        if (value.isEmpty()) {
            if (!this.canBeNull()) {
                this.addError("Field is empty");
            }
        } else {
            try {
                this.unlockCode = this.allowLabelId && value.length() == 8 ? new UnlockCode(LabelId.fromString(value), null) : UnlockCode.fromBase58(value);
            }
            catch (SerializeException exc) {
                this.addError("Not a valid unlock code" + (this.allowLabelId ? " or label ID" : "") + " - " + exc.getMessage());
            }
        }
    }
}

