/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.security.RegistrationCode;
import at.mrdevelopment.esl.gui.editor.TextEditor;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class RegistrationCodeEditor
extends TextEditor<String> {
    private final boolean allowLabelId;
    private RegistrationCode registrationCode;

    public RegistrationCodeEditor() {
        this(true, false);
    }

    public RegistrationCodeEditor(boolean allowLabelId, boolean canBeNull) {
        this.allowLabelId = allowLabelId;
        this.setCanBeNull(canBeNull);
    }

    public RegistrationCodeEditor(int length, boolean allowLabelId, boolean canBeNull) {
        this.allowLabelId = allowLabelId;
        this.setCanBeNull(canBeNull);
    }

    public String getValue() {
        return this.getEditorText();
    }

    public RegistrationCode getRegistrationCode() {
        return this.registrationCode;
    }

    public void validate() {
        super.validate();
        String value = this.getEditorText();
        if (value.isEmpty()) {
            if (!this.canBeNull()) {
                this.addError("Field is empty");
            }
        } else {
            try {
                this.registrationCode = this.allowLabelId && value.length() == 8 ? new RegistrationCode(LabelId.fromString(value), null) : RegistrationCode.fromBase58(value);
            }
            catch (SerializeException exc) {
                this.addError("Not a valid registration code" + (this.allowLabelId ? " or label ID" : "") + " - " + exc.getMessage());
            }
        }
    }
}

