/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.gui.editor.ForceUppercaseTextEditor;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class LabelIdEditor
extends ForceUppercaseTextEditor<Long> {
    private LabelId labelId;

    public LabelIdEditor() {
        this(false);
    }

    public LabelIdEditor(boolean canBeNull) {
        this.setCanBeNull(canBeNull);
    }

    public LabelIdEditor(int length, boolean canBeNull) {
        super(length);
        this.setCanBeNull(canBeNull);
    }

    public void setLabelId(LabelId labelId) {
        this.setValue(labelId != null ? Long.valueOf(labelId.getId()) : null);
    }

    public void setEditorValue(Long value) {
        if (value != null) {
            this.labelId = new LabelId(value);
            this.setEditorText(this.labelId.getLabelIdString());
        }
    }

    public Long getValue() {
        return this.labelId != null ? Long.valueOf(this.labelId.getId()) : null;
    }

    public LabelId getLabelId() {
        return this.labelId;
    }

    public void validate() {
        super.validate();
        this.labelId = null;
        String value = this.getEditorText();
        if (value.isEmpty()) {
            if (!this.canBeNull()) {
                this.addError("Field is empty");
            }
        } else {
            try {
                this.labelId = LabelId.fromString(value);
            }
            catch (SerializeException exc) {
                this.addError("Not a valid label ID");
            }
        }
    }
}

