/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SyncQuality;
import at.mrdevelopment.esl.core.WakeupListener;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.joda.time.DateTime;

public abstract class WakeupStatisticsTableModel
implements TableModel,
WakeupListener {
    static ESLLogger logger = ESLLogger.getLogger(WakeupStatisticsTableModel.class);
    private Map<Address, Integer> mapping = new HashMap<Address, Integer>();
    private List<WakeupStatistic> wakeupStatistics = new ArrayList<WakeupStatistic>();
    private Set<TableModelListener> listeners = new HashSet<TableModelListener>();

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Address.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Version.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Long.class;
            }
            case 5: {
                return DateTime.class;
            }
            case 6: {
                return PowerStatus.class;
            }
            case 7: {
                return Integer.class;
            }
            case 8: {
                return Integer.class;
            }
            case 9: {
                return SyncQuality.class;
            }
            case 10: {
                return LabelErrors.class;
            }
            case 11: {
                return Page.class;
            }
            case 12: {
                return ConnectionStatus.class;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 13;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Address";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "FW";
            }
            case 3: {
                return "AP ID";
            }
            case 4: {
                return "Count";
            }
            case 5: {
                return "Timestamp";
            }
            case 6: {
                return "Power";
            }
            case 7: {
                return "RSSI";
            }
            case 8: {
                return "LQI";
            }
            case 9: {
                return "Sync";
            }
            case 10: {
                return "Error";
            }
            case 11: {
                return "Page";
            }
            case 12: {
                return "Status";
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.wakeupStatistics.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        WakeupStatistic wakeupStatistic = this.wakeupStatistics.get(rowIndex);
        if (wakeupStatistic == null) {
            return null;
        }
        LabelId labelId = new LabelId(wakeupStatistic.getLabelAddress());
        LabelType labelType = labelId.getLabelType();
        switch (columnIndex) {
            case 0: {
                return wakeupStatistic.getLabelAddress();
            }
            case 1: {
                return labelType.toString();
            }
            case 2: {
                return wakeupStatistic.getFirmwareVersion();
            }
            case 3: {
                return wakeupStatistic.getAccessPointId();
            }
            case 4: {
                return wakeupStatistic.getWakeupCount();
            }
            case 5: {
                return wakeupStatistic.getLastPingReplyTime();
            }
            case 6: {
                return wakeupStatistic.getPowerStatus();
            }
            case 7: {
                return wakeupStatistic.getLastRssi();
            }
            case 8: {
                return wakeupStatistic.getLastLqi();
            }
            case 9: {
                return wakeupStatistic.getSyncQuality();
            }
            case 10: {
                return wakeupStatistic.getLabelErrors();
            }
            case 11: {
                return wakeupStatistic.getCurrentPage();
            }
            case 12: {
                return ConnectionStatus.getStatus((DateTime)DateTime.now(), (DateTime)wakeupStatistic.getLastPingReplyTime(), (int)this.getLabelsOfflineAfterSeconds());
            }
        }
        return null;
    }

    protected abstract int getLabelsOfflineAfterSeconds();

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    public void receivedWakeup(WakeupStatistic wakeupStatistic) {
        Integer index = this.mapping.get(wakeupStatistic.getLabelAddress());
        if (index == null) {
            this.wakeupStatistics.add(wakeupStatistic);
            index = this.wakeupStatistics.size() - 1;
            this.mapping.put(wakeupStatistic.getLabelAddress(), index);
            this.notifyIntervalAdded(index, index);
        } else {
            this.wakeupStatistics.set(index, wakeupStatistic);
            this.notifyIntervalChanged(index, index);
        }
    }

    public void receivedJoinRequest(JoinRequest joinRequest) {
    }

    public List<WakeupStatistic> getAllWakeupStatistics() {
        return this.wakeupStatistics;
    }

    public void clearMappingAndStatistics() {
        this.mapping.clear();
        this.wakeupStatistics.clear();
    }

    private void notifyIntervalAdded(int startIndex, int endIndex) {
        TableModelEvent event = new TableModelEvent(this, startIndex, endIndex, -1, 1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    protected void notifyIntervalChanged(int startIndex, int endIndex) {
        TableModelEvent event = new TableModelEvent(this, startIndex, endIndex, -1, 0);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    protected Map<Address, Integer> getMapping() {
        return this.mapping;
    }
}

