/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.wireless.Address;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class SimpleLabelTableModel
extends AbstractTableModel {
    private final List<LabelId> labels = new ArrayList<LabelId>();

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return LabelId.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Label ID";
            }
            case 1: {
                return "Label Type";
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.labels.get(rowIndex).getLabelIdString();
            }
            case 1: {
                return this.labels.get(rowIndex).getLabelType().getName();
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.labels.size();
    }

    public LabelId getLabelId(int rowIndex) {
        return this.labels.get(rowIndex);
    }

    public void addLabels(Collection<LabelId> labelsToAdd) {
        int startIndex = this.labels.size() - 1;
        for (LabelId label : labelsToAdd) {
            if (this.labels.contains(label)) continue;
            this.labels.add(label);
        }
        this.fireTableRowsInserted(startIndex, this.labels.size() - 1);
    }

    public void addLabel(LabelId label) {
        this.addLabels(Collections.singleton(label));
    }

    public void addAddresses(Collection<Address> addresses) {
        ArrayList<LabelId> labels = new ArrayList<LabelId>(addresses.size());
        for (Address address : addresses) {
            labels.add(new LabelId(address));
        }
        this.addLabels(labels);
    }

    public void removeLabels(Collection<LabelId> labelsToRemove) {
        this.labels.removeAll(labelsToRemove);
        this.fireTableStructureChanged();
    }

    public void removeLabel(LabelId label) {
        this.removeLabels(Collections.singleton(label));
    }

    public boolean contains(LabelId label) {
        return this.labels.contains(label);
    }

    public Set<LabelId> getLabels() {
        return new HashSet<LabelId>(this.labels);
    }

    public Set<Address> getAddresses() {
        HashSet<Address> addresses = new HashSet<Address>();
        for (LabelId label : this.labels) {
            addresses.add(label.toAddress());
        }
        return addresses;
    }

    public boolean isEmpty() {
        return this.labels.isEmpty();
    }
}

