/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class LabelRegistrationTableModel
extends AbstractTableModel {
    static ESLLogger logger = ESLLogger.getLogger(LabelRegistrationTableModel.class);
    private static final int LABEL_ID_COLUMN = 0;
    private static final int TYPE_COLUMN = 1;
    private static final int PIN_COLUMN = 2;
    private static final int TAG_COLUMN = 3;
    private final Map<LabelId, Integer> labels = new HashMap<LabelId, Integer>();
    private final List<LabelRegistration> registrations = new ArrayList<LabelRegistration>();

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return LabelId.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Set.class;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Label ID";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Pin";
            }
            case 3: {
                return "Tags";
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.registrations.get(row).getLabelId().getLabelIdString();
            }
            case 1: {
                return this.registrations.get(row).getLabelId().getLabelType().getName();
            }
            case 2: {
                return this.registrations.get(row).hasPin();
            }
            case 3: {
                return this.registrations.get(row).getTags();
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.registrations.size();
    }

    public void addLabel(LabelId label, Pin pin) {
        if (!this.labels.containsKey(label)) {
            int index = this.registrations.size();
            this.labels.put(label, index);
            this.registrations.add(new LabelRegistration(label, pin));
            this.fireTableRowsInserted(index, index);
        }
    }

    public void removeLabel(LabelId label) {
        if (this.labels.containsKey(label)) {
            int index = this.labels.get(label);
            this.labels.remove(label);
            this.registrations.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
        this.rebuildIndex();
    }

    public void clear() {
        if (this.registrations.size() > 0) {
            int lastRow = this.registrations.size() - 1;
            this.labels.clear();
            this.registrations.clear();
            this.fireTableRowsDeleted(0, lastRow);
        }
    }

    public Collection<LabelRegistration> getRegistrations() {
        return Collections.unmodifiableCollection(this.registrations);
    }

    public LabelRegistration getRegistration(int row) {
        return this.registrations.get(row);
    }

    public LabelId getLabel(int row) {
        return this.registrations.get(row).getLabelId();
    }

    public boolean isEmpty() {
        return this.registrations.isEmpty();
    }

    public Set<String> getTags(LabelId labelId) {
        int row = this.labels.get(labelId);
        LabelRegistration labelRegistration = this.registrations.get(row);
        return labelRegistration.getTags();
    }

    public void addTags(LabelId labelId, Set<String> tagsToAdd) {
        if (!tagsToAdd.isEmpty()) {
            int row = this.labels.get(labelId);
            LabelRegistration labelRegistration = this.registrations.get(row);
            HashSet<String> tags = new HashSet<String>(labelRegistration.getTags());
            tags.addAll(tagsToAdd);
            this.registrations.set(row, new LabelRegistration(labelId, labelRegistration.getPin(), tags));
            this.fireTableCellUpdated(row, 3);
        }
    }

    public void removeTags(LabelId labelId, Set<String> tagsToRemove) {
        int row = this.labels.get(labelId);
        LabelRegistration labelRegistration = this.registrations.get(row);
        HashSet<String> tags = new HashSet<String>(labelRegistration.getTags());
        tags.removeAll(tagsToRemove);
        this.registrations.set(row, new LabelRegistration(labelId, labelRegistration.getPin(), tags));
        this.fireTableCellUpdated(row, 3);
    }

    private void rebuildIndex() {
        this.labels.clear();
        for (int index = 0; index < this.registrations.size(); ++index) {
            LabelId label = this.registrations.get(index).getLabelId();
            this.labels.put(label, index);
        }
    }
}

