/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.firmware;

import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.firmware.FirmwareLabelTypeMapping;
import at.mrdevelopment.esl.firmware.FirmwareLoader;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.firmware.Firmware;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.SortedSet;
import org.apache.commons.exec.util.StringUtils;
import org.apache.commons.io.FilenameUtils;

public class FirmwareFileInventory {
    static ESLLogger logger = ESLLogger.getLogger(FirmwareFileInventory.class);
    private final SortedSetMultimap<LabelType, Firmware> firmwareInventory = TreeMultimap.create();

    public FirmwareFileInventory(FirmwareLoader firmwareLoader, File directory) throws InitializationException {
        logger.info("Loading firmware files from %s", new Object[]{directory.getPath()});
        if (directory.exists() && directory.isDirectory()) {
            File[] files;
            for (File file : files = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return FilenameUtils.isExtension((String)name, (String)"xml");
                }
            })) {
                String filename = FilenameUtils.getBaseName((String)file.getName());
                String[] parts = StringUtils.split((String)filename, (String)"_");
                if (parts.length >= 2) {
                    String firmwareName = parts[0];
                    Version filenameVersion = Version.fromString((String)parts[1]);
                    Collection<LabelType> labelTypes = FirmwareLabelTypeMapping.getLabelTypesForFirmwareName(firmwareName);
                    try {
                        Firmware firmware = firmwareLoader.loadFirmware(file);
                        Version firmwareVersion = firmware.getVersion();
                        if (filenameVersion.compareTo(firmwareVersion) != 0) {
                            logger.warn("Version mismatch in file %s", new Object[]{file.getName()});
                        }
                        for (LabelType labelType : labelTypes) {
                            logger.info("Adding firmware version %s for label type %s (%s, %s)", new Object[]{firmwareVersion.toString(), labelType.getName(), labelType.toString(), file.getName()});
                            this.firmwareInventory.put((Object)labelType, (Object)firmware);
                        }
                        continue;
                    }
                    catch (IOException exc) {
                        logger.logExceptionIfDebugEnabled((Throwable)exc);
                        logger.info("Could not read firmware file %s", new Object[]{file.getName()});
                        continue;
                    }
                    catch (SerializeException exc) {
                        logger.logExceptionIfDebugEnabled((Throwable)exc);
                        logger.info("Could not read firmware file %s", new Object[]{file.getName()});
                        continue;
                    }
                }
                logger.info("Ignoring file %s", new Object[]{file.getName()});
            }
        }
    }

    public Firmware getLatestVersion(LabelType labelType) {
        SortedSet available = this.firmwareInventory.get((Object)labelType);
        if (available.isEmpty()) {
            return null;
        }
        return (Firmware)available.last();
    }
}

