/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.csvimport;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.security.RegistrationCode;
import at.mrdevelopment.esl.csvimport.CsvImport;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.List;

public class RegistrationCodeCsvImport
extends CsvImport<RegistrationCode> {
    @Override
    protected List<RegistrationCode> importRecords(List<String[]> records) throws SerializeException {
        ArrayList<RegistrationCode> registrationCodes = new ArrayList<RegistrationCode>(records.size());
        for (String[] record : records) {
            String code = record[0];
            RegistrationCode registrationCode = this.parseCode(code);
            registrationCodes.add(registrationCode);
        }
        return registrationCodes;
    }

    private RegistrationCode parseCode(String code) throws SerializeException {
        if (code.length() == 8) {
            LabelId labelId = LabelId.fromString(code);
            return new RegistrationCode(labelId, null);
        }
        return RegistrationCode.fromBase58(code);
    }
}

