/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.csvimport;

import at.mrdevelopment.esl.csvimport.CsvImport;
import at.mrdevelopment.esl.type.Article;
import at.mrdevelopment.esl.type.ArticleNumber;
import at.mrdevelopment.esl.type.Gtin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ArticleCsvImport
extends CsvImport<Article> {
    @Override
    protected List<Article> importRecords(List<String[]> records) {
        ArrayList<Article> articles = new ArrayList<Article>(records.size());
        for (String[] record : records) {
            ArticleNumber articleNumber = ArticleNumber.fromString((String)record[0]);
            HashSet<Gtin> gtins = new HashSet<Gtin>();
            HashMap<String, String> fields = new HashMap<String, String>();
            for (String gtinString : StringUtils.split((String)record[1], (String)",")) {
                gtins.add(Gtin.fromString((String)gtinString));
            }
            for (int index = 2; index < record.length; ++index) {
                String[] parts = StringUtils.split((String)record[index], (String)"=", (int)2);
                if (parts.length == 1) {
                    fields.put(parts[0], "");
                    continue;
                }
                if (parts.length != 2) continue;
                fields.put(parts[0], parts[1]);
            }
            Article article = new Article(articleNumber, gtins, fields);
            articles.add(article);
        }
        return articles;
    }
}

