/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.security;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.security.Puk;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.Base58;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public class UnlockCode {
    public static final int LENGTH = 30;
    public static final int LENGTH_WITHOUT_CHECKSUM = 29;
    private static final byte[] PADDING = new byte[]{127};
    private final LabelId labelId;
    private final Puk puk;

    public static UnlockCode fromBase58(String encodedWithChecksum) throws SerializeException {
        if (encodedWithChecksum.length() != 30) {
            throw new SerializeException("Invalid unlock code length", new Object[0]);
        }
        String encoded = encodedWithChecksum.substring(0, 29);
        char checksum = encodedWithChecksum.charAt(29);
        if (Base58.calculateCheckSum((String)encoded) != checksum) {
            throw new SerializeException("Invalid checksum", new Object[0]);
        }
        byte[] decoded = Base58.decode((String)encoded);
        if (decoded == null) {
            throw new SerializeException("Unlock code contains illegal characters", new Object[0]);
        }
        byte padding = decoded[0];
        if (padding != PADDING[0]) {
            throw new SerializeException("Not a valid unlock code (wrong padding", new Object[0]);
        }
        Puk puk = Puk.fromBytes((byte[])Arrays.copyOfRange(decoded, 1, 17));
        LabelId labelId = new LabelId(Address.fromByteArray((byte[])Arrays.copyOfRange(decoded, 17, 21)));
        labelId.validate();
        return new UnlockCode(labelId, puk);
    }

    public UnlockCode(LabelId labelId, Puk puk) {
        this.labelId = labelId;
        this.puk = puk;
    }

    public LabelId getLabelId() {
        return this.labelId;
    }

    public Puk getPuk() {
        return this.puk;
    }

    public String toBase58() {
        byte[] input = ArrayUtils.addAll((byte[])this.puk.toBytes(), (byte[])this.labelId.toAddress().toByteArray());
        byte[] paddedInput = ArrayUtils.addAll((byte[])PADDING, (byte[])input);
        return Base58.encodeWithChecksum((byte[])paddedInput);
    }

    public String toString() {
        return this.toBase58();
    }
}

