/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.DefaultLabelTypeMapping;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class LabelId
implements Comparable<LabelId> {
    public static final int LABEL_ID_LENGTH = 8;
    public static final long MIN_LABEL_ID = 0x10000000L;
    public static final long MAX_LABEL_ID = 0xFFFFFFFEL;
    private final long labelId;

    public static LabelId fromString(String labelIdString) throws SerializeException {
        if (labelIdString == null || labelIdString.isEmpty()) {
            throw new SerializeException("Label ID is empty", new Object[0]);
        }
        try {
            long id = Long.parseLong(labelIdString, 16);
            LabelId labelId = new LabelId(id);
            labelId.validate();
            return labelId;
        }
        catch (NumberFormatException exc) {
            throw new SerializeException("Could not parse label ID from '%s'", new Object[]{labelIdString});
        }
    }

    public LabelId(long labelId) {
        this.labelId = labelId;
    }

    public LabelId(Address address) {
        this.labelId = address.getHardwareAddress();
    }

    public long getId() {
        return this.labelId;
    }

    public String getLabelIdString() {
        return String.format("%08X", this.labelId);
    }

    public Address toAddress() {
        return Address.fromId((long)this.labelId);
    }

    public LabelType getLabelType() {
        return DefaultLabelTypeMapping.getType(this.labelId);
    }

    public void validate() throws SerializeException {
        if ((this.labelId & 0xFFL) == 255L) {
            throw new SerializeException("Label ID must not end with FF", new Object[0]);
        }
        if (this.labelId < 0x10000000L || this.labelId > 0xFFFFFFFEL) {
            throw new SerializeException("Label ID '%s' is out of valid range", new Object[]{this.getLabelIdString()});
        }
    }

    public String toString() {
        return String.format("[%08X]", this.labelId);
    }

    public int hashCode() {
        return Long.valueOf(this.labelId).hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof LabelId)) {
            return false;
        }
        return this.labelId == ((LabelId)other).labelId;
    }

    @Override
    public int compareTo(LabelId other) {
        return Long.valueOf(this.labelId).compareTo(other.labelId);
    }

    public boolean isLicenseRequired() {
        return this.labelId >= 0xB2000000L && this.labelId <= 3003121662L;
    }
}

