/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.labeltype.LabelTypeMapping;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum DefaultLabelTypeMapping implements LabelTypeMapping
{
    INSTANCE;

    private final Map<Integer, LabelType> labelTypeMapping = new HashMap<Integer, LabelType>();

    private DefaultLabelTypeMapping() {
        this.labelTypeMapping.put(29, LabelType.BATTERY_SEGMENTED);
        this.labelTypeMapping.put(30, LabelType.BATTERY_SEGMENTED);
        this.labelTypeMapping.put(31, LabelType.BATTERY_SEGMENTED);
        this.labelTypeMapping.put(161, LabelType.BATTERY_200);
        this.labelTypeMapping.put(162, LabelType.BATTERY_200_FLIPPED);
        this.labelTypeMapping.put(163, LabelType.SES_GTAG_6);
        this.labelTypeMapping.put(177, LabelType.BATTERY_270_FLIPPED);
        this.labelTypeMapping.put(178, LabelType.BATTERY_270_BILLA);
        this.labelTypeMapping.put(179, LabelType.BATTERY_270);
        this.labelTypeMapping.put(180, LabelType.BATTERY_270);
        this.labelTypeMapping.put(191, LabelType.BATTERY_270);
        this.labelTypeMapping.put(193, LabelType.BATTERY_441);
        this.labelTypeMapping.put(194, LabelType.BATTERY_441_FLIPPED);
        this.labelTypeMapping.put(195, LabelType.BATTERY_441_SPECTRA);
        this.labelTypeMapping.put(209, LabelType.BATTERY_740);
        this.labelTypeMapping.put(210, LabelType.BATTERY_740_FLIPPED);
        this.labelTypeMapping.put(211, LabelType.BATTERY_740_SPECTRA);
        this.labelTypeMapping.put(225, LabelType.BATTERY_1020);
        this.labelTypeMapping.put(226, LabelType.BATTERY_1020_FLIPPED);
    }

    public Map<Integer, LabelType> getMapping() {
        return Collections.unmodifiableMap(this.labelTypeMapping);
    }

    public LabelType getTypeForLabelId(LabelId labelId) {
        return this.getTypeForLabelId(labelId.getId());
    }

    public LabelType getTypeForLabelId(long labelId) {
        int code = (int)(labelId >> 24);
        LabelType labelType = this.labelTypeMapping.get(code);
        return labelType != null ? labelType : LabelType.UNKNOWN;
    }

    public static LabelType getType(long labelId) {
        return INSTANCE.getTypeForLabelId(labelId);
    }

    public static Set<Integer> getCodesForType(LabelType labelType) {
        HashSet<Integer> codes = new HashSet<Integer>();
        for (Map.Entry<Integer, LabelType> entry : DefaultLabelTypeMapping.INSTANCE.labelTypeMapping.entrySet()) {
            if (entry.getValue() != labelType) continue;
            codes.add(entry.getKey());
        }
        return codes;
    }
}

