/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.WirelessChannel;
import com.google.common.base.Strings;

public class AccessPointRegistration {
    private final int accessPointId;
    private final ServiceAddress serviceAddress;
    private final Configuration configuration;

    public AccessPointRegistration(int accessPointId, ServiceAddress serviceAddress, Configuration configuration) {
        this.accessPointId = accessPointId;
        this.serviceAddress = serviceAddress;
        this.configuration = configuration;
    }

    public int getAccessPointId() {
        return this.accessPointId;
    }

    public ServiceAddress getServiceAddress() {
        return this.serviceAddress;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static class Configuration {
        private final String hostName;
        private final String staticIpAddress;
        private final String subnetMask;
        private final String gateway;
        private final String dns;
        private final WirelessChannel channel;

        public Configuration() {
            this(null, null, null, null, null, null);
        }

        public Configuration(String hostName, String staticIpAddress, String subnetMask, String gateway, String dns, WirelessChannel channel) {
            this.hostName = hostName;
            this.staticIpAddress = staticIpAddress;
            this.subnetMask = subnetMask;
            this.gateway = gateway;
            this.dns = dns;
            this.channel = channel;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getStaticIpAddress() {
            return this.staticIpAddress;
        }

        public String getSubnetMask() {
            return this.subnetMask;
        }

        public String getGateway() {
            return this.gateway;
        }

        public String getDns() {
            return this.dns;
        }

        public WirelessChannel getChannel() {
            return this.channel;
        }

        public boolean isEmpty() {
            return Strings.isNullOrEmpty((String)this.hostName) && Strings.isNullOrEmpty((String)this.staticIpAddress) && Strings.isNullOrEmpty((String)this.subnetMask) && Strings.isNullOrEmpty((String)this.gateway) && Strings.isNullOrEmpty((String)this.dns) && this.channel == null;
        }

        public boolean isValid() {
            return !Strings.isNullOrEmpty((String)this.hostName) && !Strings.isNullOrEmpty((String)this.staticIpAddress) && !Strings.isNullOrEmpty((String)this.subnetMask) && this.channel != null;
        }
    }
}

