/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.ESLProcessing;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.PeriodicTasksExecutor;
import at.mrdevelopment.esl.core.UpdateResultListener;
import at.mrdevelopment.esl.core.WakeupListener;
import at.mrdevelopment.esl.core.WakeupNotifier;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.type.UpdateResult;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractESLProcessing
implements ESLProcessing,
PeriodicTasksExecutor,
WakeupNotifier {
    static ESLLogger logger = ESLLogger.getLogger(AbstractESLProcessing.class);
    private final List<ESLProcessingTask> processingTasks = new ArrayList<ESLProcessingTask>();
    private final List<WakeupListener> wakeupListeners = new LinkedList<WakeupListener>();
    private final List<UpdateResultListener> updateResultListeners = new LinkedList<UpdateResultListener>();
    private final List<Shutdownable> shutdownables = new LinkedList<Shutdownable>();

    public void performPeriodicTasks() {
        for (ESLProcessingTask processingTask : this.processingTasks) {
            try {
                processingTask.run();
            }
            catch (WebserviceException exc) {
                logger.error("Could not connect to access point (%s)", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            catch (DatasetException exc) {
                logger.error("Could not persist to database (%s)", new Object[]{exc.getMessage()});
                logger.logException((Throwable)exc);
            }
            catch (SerializeException exc) {
                logger.error("Could not serialize object (%s)", new Object[]{exc.getMessage()});
                logger.logException((Throwable)exc);
            }
            catch (Exception exc) {
                logger.error("Unknown exception during service processing (%s)", new Object[]{exc.getMessage()});
                logger.logException((Throwable)exc);
            }
        }
    }

    public void registerWakeupListener(WakeupListener listener) {
        this.wakeupListeners.add(listener);
    }

    public void unregisterWakeupListener(WakeupListener listener) {
        this.wakeupListeners.remove(listener);
    }

    @Override
    public void registerUpdateResultListener(UpdateResultListener listener) {
        logger.info("Registering update result listener %s", new Object[]{listener.getClass().getName()});
        this.updateResultListeners.add(listener);
    }

    @Override
    public void unregisterUpdateResultListener(UpdateResultListener listener) {
        this.updateResultListeners.remove(listener);
    }

    @Override
    public void registerShutdownable(Shutdownable shutdownable) {
        this.shutdownables.add(shutdownable);
    }

    @Override
    public void unregisterShutdownable(Shutdownable shutdownable) {
        this.shutdownables.remove(shutdownable);
    }

    public void shutdown() {
        logger.info("Shutdown ESL processing");
        this.shutdownShutdownables();
    }

    @Override
    public void addProcessingTask(ESLProcessingTask processingTask) {
        this.processingTasks.add(processingTask);
    }

    protected boolean hasProcessingTasks() {
        return this.processingTasks.size() > 0;
    }

    public void notifyReceivedWakeup(WakeupStatistic wakeupStatistic) {
        for (WakeupListener listener : this.wakeupListeners) {
            listener.receivedWakeup(wakeupStatistic);
        }
    }

    public void notifyReceivedJoinRequest(JoinRequest joinRequest) {
        for (WakeupListener listener : this.wakeupListeners) {
            listener.receivedJoinRequest(joinRequest);
        }
    }

    protected void notifyUpdateFinished(UpdateResult updateResult) {
        for (UpdateResultListener listener : this.updateResultListeners) {
            try {
                listener.updateFinished(updateResult);
            }
            catch (Exception exc) {
                logger.error("Error while writing task result to %s for task %s", new Object[]{listener.getClass().getName(), updateResult.getTaskId()});
                logger.logException((Throwable)exc);
            }
        }
    }

    private void shutdownShutdownables() {
        for (Shutdownable shutdownable : this.shutdownables) {
            logger.info("Shutdown %s", new Object[]{shutdownable.getClass().getName()});
            shutdownable.shutdown();
        }
    }
}

