/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.toolkit.Version;

public class AccessPointServiceStatus {
    private final ServiceStatus serviceStatus;

    public AccessPointServiceStatus(ServiceStatus serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    public ServiceStatus getServiceStatus() {
        return this.serviceStatus;
    }

    public String getAdapterName() {
        return this.serviceStatus.getPropertyValue("adapter-name");
    }

    public Boolean isAutoConfig() {
        String value = this.serviceStatus.getPropertyValue("auto-config");
        return this.isValidString(value) ? Boolean.valueOf(value) : null;
    }

    public String getBroadcastAddress() {
        return this.serviceStatus.getPropertyValue("broadcast");
    }

    public int getBuild() {
        String value = this.serviceStatus.getPropertyValue("build");
        return this.isValidString(value) ? Integer.valueOf(value) : 0;
    }

    public WirelessChannel getChannel() {
        String value = this.serviceStatus.getPropertyValue("channel");
        return this.isValidString(value) ? WirelessChannel.fromString((String)value) : null;
    }

    public String getServer() {
        return this.serviceStatus.getPropertyValue("server-hostname");
    }

    public String getDeviceType() {
        return this.serviceStatus.getPropertyValue("device-type");
    }

    public Version getFirmwareVersion() {
        String value = this.serviceStatus.getPropertyValue("firmware-version");
        return this.isValidString(value) ? Version.fromString((String)value) : null;
    }

    public int getHardwareRevision() {
        String value = this.serviceStatus.getPropertyValue("hardware-revision");
        return this.isValidString(value) ? Integer.valueOf(value).intValue() : this.getDeprecatedHardwareRevision();
    }

    private int getDeprecatedHardwareRevision() {
        String value = this.serviceStatus.getPropertyValue("hardware-version");
        return this.isValidString(value) ? Integer.valueOf(value) : 0;
    }

    public String getHostname() {
        return this.serviceStatus.getPropertyValue("hostname");
    }

    public int getAccessPointId() {
        String value = this.serviceStatus.getPropertyValue("id");
        return this.isValidString(value) ? Integer.valueOf(value) : 0;
    }

    public String getSerial() {
        return this.serviceStatus.getPropertyValue("serial");
    }

    public boolean hasValidRoamingTable() {
        String value = this.serviceStatus.getPropertyValue("roaming-table-valid");
        return this.isValidString(value) ? Boolean.valueOf(value) : false;
    }

    public int getPingIntervall() {
        return Integer.parseInt(this.serviceStatus.getPropertyValue("ping-interval").split(" ")[0]);
    }

    public int getTasksCount() {
        String value = this.serviceStatus.getPropertyValue("tasks");
        return this.isValidString(value) ? Integer.valueOf(value) : 0;
    }

    public int getTasksSize() {
        String value = this.serviceStatus.getPropertyValue("task-size");
        return this.isValidString(value) ? Integer.valueOf(value) : 0;
    }

    public Version getVersion() {
        String value = this.serviceStatus.getPropertyValue("version");
        return this.isValidString(value) ? Version.fromString((String)value) : null;
    }

    private boolean isValidString(String string) {
        return string != null && !string.isEmpty();
    }
}

