/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceClient;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.file.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class AccessPointServiceFactory {
    public Collection<ServiceAddress> loadAddressesFromFile(File configFile) throws InitializationException {
        try {
            return this.loadAddresses(FileUtils.readLines((File)configFile));
        }
        catch (FileNotFoundException exc) {
            throw new InitializationException("Could not find configuration file '%s'", new Object[]{configFile.getAbsolutePath()});
        }
        catch (IOException exc) {
            throw new InitializationException((Throwable)exc, "Could not read configuration file '%s'", new Object[]{configFile.getAbsolutePath()});
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public Collection<ServiceAddress> loadAddresses(List<String> connectionStrings) throws MalformedURLException {
        ArrayList<ServiceAddress> addresses = new ArrayList<ServiceAddress>(connectionStrings.size());
        for (String line : connectionStrings) {
            if (line.startsWith("#")) continue;
            addresses.add(ServiceAddress.fromString((String)line));
        }
        return addresses;
    }

    public ServiceAddress loadAddress(String connectionLine) throws MalformedURLException {
        return ServiceAddress.fromString((String)connectionLine);
    }

    public Collection<AccessPointService> createServiceInstances(Collection<ServiceAddress> accessPointAddresses) throws InitializationException {
        int accessPointId = 0;
        LinkedList<AccessPointService> services = new LinkedList<AccessPointService>();
        for (ServiceAddress address : accessPointAddresses) {
            AccessPointServiceClient accessPointService = new AccessPointServiceClient(accessPointId, address);
            services.add(accessPointService);
            ++accessPointId;
        }
        return services;
    }

    public AccessPointService createServiceInstance(Integer accessPointId, String address, String username, String password) throws MalformedURLException, InitializationException {
        ServiceAddress serviceAddress = ServiceAddress.fromString((String)address);
        serviceAddress = new ServiceAddress(serviceAddress.useSSL(), serviceAddress.getHost(), serviceAddress.getPort(), username, password);
        return new AccessPointServiceClient(accessPointId, serviceAddress);
    }
}

