/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointDefaultRequestStrategy;
import at.mrdevelopment.esl.accesspoint.AccessPointReplyCallback;
import at.mrdevelopment.esl.accesspoint.AccessPointRequestStrategy;
import at.mrdevelopment.esl.accesspoint.AccessPointRequestStrategyFactory;
import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.admin.AccessPointConfiguration;
import at.mrdevelopment.esl.admin.AccessPointConfigurationXMLSerializer;
import at.mrdevelopment.esl.core.DefaultLabelTypeResolver;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.core.UpdateCreationException;
import at.mrdevelopment.esl.core.labeltype.LabelTypeResolver;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.esl.updatetask.UpdateTaskXMLSerializer;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.esl.xml.JoinRequestXMLSerializer;
import at.mrdevelopment.esl.xml.RoamingTableXMLSerializer;
import at.mrdevelopment.esl.xml.ServiceStatusXMLSerializer;
import at.mrdevelopment.esl.xml.WakeupStatisticXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.http.HttpServiceClient;
import at.mrdevelopment.toolkit.http.IgnoreResponseHandler;
import at.mrdevelopment.toolkit.http.ResponseHandler;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.w3c.dom.Document;

public class AccessPointServiceClient
implements AccessPointService {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointServiceClient.class);
    private final ServiceAddress serviceAddress;
    private final HttpServiceClient httpServiceClient;
    private final WakeupStatisticXMLSerializer xmlStatistics;
    private final JoinRequestXMLSerializer xmlJoinRequests;
    private final UpdateTaskXMLSerializer xmlUpdateTasks;
    private final RoamingTableXMLSerializer xmlRoamingTable;
    private final ServiceStatusXMLSerializer xmlServiceStatus;
    private final AccessPointConfigurationXMLSerializer xmlAccessPointConfiguration;
    private final XMLContentProducerFactory contentProducerFactory;
    private final Map<UUID, UpdateTask> scheduledUpdateTasks = new HashMap<UUID, UpdateTask>();
    private final List<UUID> tasksToRemove = new LinkedList<UUID>();
    private final List<UUID> tasksToAbort = new LinkedList<UUID>();
    private int accessPointId;
    private AccessPointRequestStrategy requestStrategy = new AccessPointDefaultRequestStrategy();
    private DateTime lastAssignedLabelsQueryTime = null;
    private DateTime lastDiscoveredLabelsQueryTime = null;
    private int scheduledUpdateTasksSize = 0;
    private boolean useOldSerialization = false;

    public AccessPointServiceClient(int accessPointId, ServiceAddress serviceAddress) throws InitializationException {
        this.accessPointId = accessPointId;
        this.serviceAddress = serviceAddress;
        this.httpServiceClient = new HttpServiceClient(serviceAddress.getHost(), serviceAddress.getPort(), serviceAddress.useSSL());
        if (serviceAddress.hasCredentials()) {
            this.httpServiceClient.setCredentials(serviceAddress.getUsername(), serviceAddress.getPassword());
        }
        this.xmlStatistics = new WakeupStatisticXMLSerializer();
        this.xmlJoinRequests = new JoinRequestXMLSerializer();
        this.xmlUpdateTasks = new UpdateTaskXMLSerializer((LabelTypeResolver)new DefaultLabelTypeResolver());
        this.xmlRoamingTable = new RoamingTableXMLSerializer();
        this.xmlServiceStatus = new ServiceStatusXMLSerializer();
        this.xmlAccessPointConfiguration = new AccessPointConfigurationXMLSerializer();
        this.contentProducerFactory = XMLContentProducerFactory.newInstance();
    }

    @Override
    public int getAccessPointId() {
        return this.accessPointId;
    }

    @Override
    public ServiceAddress getServiceAddress() {
        return this.serviceAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleUpdateTask(UpdateTask updateTask) throws UpdateCreationException {
        if (!this.requestStrategy.isTaskSupported(updateTask)) {
            throw new UpdateCreationException(UpdateError.ERROR_CODE_UNSUPPORTED_TASK);
        }
        Map<UUID, UpdateTask> map = this.scheduledUpdateTasks;
        synchronized (map) {
            this.scheduledUpdateTasks.put(updateTask.getTaskId(), updateTask);
            this.scheduledUpdateTasksSize += updateTask.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleTaskForRemoval(UUID taskId) {
        List<UUID> list = this.tasksToRemove;
        synchronized (list) {
            this.tasksToRemove.add(taskId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleTaskForAborting(UUID taskId) {
        List<UUID> list = this.tasksToAbort;
        synchronized (list) {
            this.tasksToAbort.add(taskId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUpdateTaskIfScheduled(UUID taskId) {
        Map<UUID, UpdateTask> map = this.scheduledUpdateTasks;
        synchronized (map) {
            UpdateTask updateTask = this.scheduledUpdateTasks.remove(taskId);
            this.scheduledUpdateTasksSize -= updateTask != null ? updateTask.getSize() : 0;
            return updateTask != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScheduledUpdateTasksSize() {
        Map<UUID, UpdateTask> map = this.scheduledUpdateTasks;
        synchronized (map) {
            return this.scheduledUpdateTasksSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScheduledUpdateTaskCount() {
        Map<UUID, UpdateTask> map = this.scheduledUpdateTasks;
        synchronized (map) {
            return this.scheduledUpdateTasks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendScheduledUpdateTasks() throws WebserviceException, SerializeException {
        Map<UUID, UpdateTask> map = this.scheduledUpdateTasks;
        synchronized (map) {
            if (!this.scheduledUpdateTasks.isEmpty()) {
                try {
                    Document document = this.xmlUpdateTasks.toXML(this.scheduledUpdateTasks.values(), true, this.useOldSerialization);
                    HttpPost request = new HttpPost("/service/tasks/add.xml");
                    request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
                    this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
                }
                finally {
                    this.scheduledUpdateTasks.clear();
                    this.scheduledUpdateTasksSize = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendScheduledRemoveRequests() throws WebserviceException, SerializeException {
        List<UUID> list = this.tasksToRemove;
        synchronized (list) {
            if (!this.tasksToRemove.isEmpty()) {
                int count = Math.min(this.tasksToRemove.size(), 1000);
                List<UUID> subList = this.tasksToRemove.subList(0, count);
                try {
                    this.requestStrategy.removeTasks(this.httpServiceClient, subList);
                }
                finally {
                    subList.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendScheduledAbortRequests() throws WebserviceException, SerializeException {
        List<UUID> list = this.tasksToAbort;
        synchronized (list) {
            if (!this.tasksToAbort.isEmpty()) {
                int count = Math.min(this.tasksToAbort.size(), 1000);
                List<UUID> subList = this.tasksToAbort.subList(0, count);
                try {
                    this.requestStrategy.abortTasks(this.httpServiceClient, subList);
                }
                finally {
                    subList.clear();
                }
            }
        }
    }

    @Override
    public void sendConfiguration(AccessPointConfiguration accessPointConfiguration) throws WebserviceException, SerializeException {
        Document document = this.xmlAccessPointConfiguration.toXML(accessPointConfiguration);
        HttpPost request = new HttpPost("/service/config/all.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
    }

    @Override
    public void sendRoamingTable(RoamingTable roamingTable) throws WebserviceException, SerializeException {
        logger.info("Sending roaming table with %d entries to access point %d", new Object[]{roamingTable.getSize(), this.accessPointId});
        Document document = this.xmlRoamingTable.toXML(roamingTable);
        HttpPost request = new HttpPost("/service/labels/assignment.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
    }

    @Override
    public void sendSoftwareUpdate(File file) throws WebserviceException {
        logger.info("Sending software update to access point");
        MultipartEntity multipartEntity = new MultipartEntity();
        FileBody contentBodyFile = new FileBody(file, "multipart/form-data");
        multipartEntity.addPart("file", (ContentBody)contentBodyFile);
        HttpPost request = new HttpPost("/service/config/software/upload.html");
        request.setEntity((HttpEntity)multipartEntity);
        this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
    }

    public void shutdown() {
        this.httpServiceClient.close();
    }

    @Override
    public void queryServiceStatus(AccessPointReplyCallback callback) {
        try {
            HttpGet request = new HttpGet("/service/status.xml");
            ServiceStatus serviceStatus = (ServiceStatus)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<ServiceStatus>(){

                public ServiceStatus handleResponse(HttpResponse response) throws SerializeException, IOException {
                    InputStream inputStream = response.getEntity().getContent();
                    return AccessPointServiceClient.this.xmlServiceStatus.parseXML(inputStream);
                }
            });
            AccessPointServiceStatus accessPointServiceStatus = new AccessPointServiceStatus(serviceStatus);
            this.loadRequestStrategy(accessPointServiceStatus);
            this.accessPointId = accessPointServiceStatus.getAccessPointId();
            callback.processServiceStatus(this, accessPointServiceStatus);
        }
        catch (WebserviceException exc) {
            logger.warn(exc.getMessage());
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            callback.failedToQueryAccessPoint(this);
        }
    }

    private void loadRequestStrategy(AccessPointServiceStatus accessPointServiceStatus) {
        Version version = accessPointServiceStatus.getVersion();
        this.requestStrategy = AccessPointRequestStrategyFactory.getStrategyForVersion(version, this.httpServiceClient, this.contentProducerFactory);
    }

    @Override
    public void queryAssignedLabels(AccessPointReplyCallback callback) {
        Collection<Object> receivedWakeupStatistics = null;
        try {
            int seconds = this.getSecondsForQuery(this.lastAssignedLabelsQueryTime);
            String queryUrl = this.requestStrategy.getQueryAssignedLabelsUrl(seconds);
            HttpGet request = new HttpGet(queryUrl);
            receivedWakeupStatistics = (Collection)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Collection<WakeupStatistic>>(){

                public Collection<WakeupStatistic> handleResponse(HttpResponse response) throws SerializeException, IOException {
                    InputStream inputStream = response.getEntity().getContent();
                    return AccessPointServiceClient.this.xmlStatistics.parseXML(inputStream);
                }
            });
            this.lastAssignedLabelsQueryTime = DateTime.now();
        }
        catch (WebserviceException exc) {
            receivedWakeupStatistics = Collections.emptyList();
            logger.warn(exc.getMessage());
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            callback.failedToQueryAccessPoint(this);
        }
        callback.processWakeupStatistics(receivedWakeupStatistics);
    }

    @Override
    public void queryDiscoveredLabels(AccessPointReplyCallback callback) {
        Collection<Object> receivedJoinRequests = null;
        try {
            int seconds = this.getSecondsForQuery(this.lastDiscoveredLabelsQueryTime);
            String queryUrl = this.requestStrategy.getQueryDiscoveredLabelsUrl(seconds);
            HttpGet request = new HttpGet(queryUrl);
            receivedJoinRequests = (Collection)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Collection<JoinRequest>>(){

                public Collection<JoinRequest> handleResponse(HttpResponse response) throws SerializeException, IOException {
                    InputStream inputStream = response.getEntity().getContent();
                    return AccessPointServiceClient.this.xmlJoinRequests.parseXML(inputStream);
                }
            });
            this.lastDiscoveredLabelsQueryTime = DateTime.now();
        }
        catch (WebserviceException exc) {
            receivedJoinRequests = Collections.emptyList();
            logger.warn(exc.getMessage());
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            callback.failedToQueryAccessPoint(this);
        }
        callback.processJoinRequests(receivedJoinRequests);
    }

    @Override
    public void queryUpdateTasks(AccessPointReplyCallback callback) throws DatasetException {
        Collection<Object> receivedTasks = null;
        try {
            String queryUrl = this.requestStrategy.getQueryUpdateTasksUrl();
            HttpGet request = new HttpGet(queryUrl);
            receivedTasks = (Collection)this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Collection<UpdateTask>>(){

                public Collection<UpdateTask> handleResponse(HttpResponse response) throws SerializeException, IOException {
                    InputStream inputStream = response.getEntity().getContent();
                    return AccessPointServiceClient.this.xmlUpdateTasks.parseXML(inputStream);
                }
            });
        }
        catch (WebserviceException exc) {
            receivedTasks = Collections.emptyList();
            logger.warn(exc.getMessage());
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            callback.failedToQueryAccessPoint(this);
        }
        callback.processUpdateTasks(this.accessPointId, receivedTasks);
    }

    @Override
    public void queryLabelEvents(AccessPointReplyCallback callback) {
        List<LabelEvent> labelEvents = null;
        try {
            labelEvents = this.requestStrategy.queryLabelEvents(this.httpServiceClient);
        }
        catch (WebserviceException exc) {
            labelEvents = Collections.emptyList();
            logger.warn(exc.getMessage());
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            callback.failedToQueryAccessPoint(this);
        }
        callback.processLabelEvents(this.accessPointId, labelEvents);
    }

    private int getSecondsForQuery(DateTime time) {
        return time != null ? Seconds.secondsBetween((ReadableInstant)time, (ReadableInstant)DateTime.now()).getSeconds() + 15 : 0;
    }

    public void setUseOldVersionXMLSerialization(boolean useOldSerialization) {
        this.useOldSerialization = useOldSerialization;
    }
}

