/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointDefaultRequestStrategy;
import at.mrdevelopment.esl.accesspoint.AccessPointImprovedRequestStrategy;
import at.mrdevelopment.esl.accesspoint.AccessPointRequestStrategy;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.http.HttpServiceClient;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class AccessPointRequestStrategyFactory {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointRequestStrategyFactory.class);

    public static AccessPointRequestStrategy getStrategyForVersion(Version version, HttpServiceClient httpServiceClient, XMLContentProducerFactory contentProducerFactory) {
        try {
            if (version.isEqualOrNewer(AccessPointImprovedRequestStrategy.VERSION)) {
                logger.debug("Loading request strategy for access point with version %s", new Object[]{version});
                return new AccessPointImprovedRequestStrategy(contentProducerFactory);
            }
        }
        catch (InitializationException exc) {
            logger.warn("Failed to create request strategy for access point with version %s", new Object[]{version});
        }
        return new AccessPointDefaultRequestStrategy();
    }
}

