/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointRequestStrategy;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.esl.xml.LabelEventXMLSerializer;
import at.mrdevelopment.esl.xml.TaskIdXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.http.HttpServiceClient;
import at.mrdevelopment.toolkit.http.IgnoreResponseHandler;
import at.mrdevelopment.toolkit.http.ResponseHandler;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.EntityTemplate;
import org.w3c.dom.Document;

public class AccessPointImprovedRequestStrategy
implements AccessPointRequestStrategy {
    public static Version VERSION = Version.fromString((String)"1.1.0");
    private final XMLContentProducerFactory contentProducerFactory;
    private final TaskIdXMLSerializer xmlTasksIds;
    private final LabelEventXMLSerializer xmlLabelEvents;

    public AccessPointImprovedRequestStrategy(XMLContentProducerFactory contentProducerFactory) throws InitializationException {
        this.contentProducerFactory = contentProducerFactory;
        this.xmlTasksIds = new TaskIdXMLSerializer();
        this.xmlLabelEvents = new LabelEventXMLSerializer();
    }

    @Override
    public boolean isTaskSupported(UpdateTask updateTask) {
        return true;
    }

    @Override
    public String getQueryAssignedLabelsUrl(int seconds) {
        return String.format("/service/labels/lastseenwithinseconds/%d.xml", seconds);
    }

    @Override
    public String getQueryDiscoveredLabelsUrl(int seconds) {
        return String.format("/service/labels/accepted/withinseconds/%d.xml", seconds);
    }

    @Override
    public String getQueryUpdateTasksUrl() {
        return "/service/tasks/finished.xml";
    }

    @Override
    public void abortTasks(HttpServiceClient httpServiceClient, Collection<UUID> tasks) throws WebserviceException, SerializeException {
        Document document = this.xmlTasksIds.toXML(tasks);
        HttpPost request = new HttpPost("/service/tasks/abort.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
    }

    @Override
    public void removeTasks(HttpServiceClient httpServiceClient, Collection<UUID> tasks) throws WebserviceException, SerializeException {
        Document document = this.xmlTasksIds.toXML(tasks);
        HttpPost request = new HttpPost("/service/tasks/remove.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
    }

    @Override
    public Collection<LabelEvent> queryLabelEvents(HttpServiceClient httpServiceClient) throws WebserviceException {
        HttpGet request = new HttpGet("/service/labels/events.xml");
        return (Collection)httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Collection<LabelEvent>>(){

            public Collection<LabelEvent> handleResponse(HttpResponse response) throws SerializeException, IOException {
                InputStream inputStream = response.getEntity().getContent();
                return AccessPointImprovedRequestStrategy.this.xmlLabelEvents.parseXML(inputStream);
            }
        });
    }
}

