/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointRequestStrategy;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.updatetask.PingUpdateTask;
import at.mrdevelopment.esl.updatetask.RebootUpdateTask;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.toolkit.http.HttpServiceClient;
import at.mrdevelopment.toolkit.http.IgnoreResponseHandler;
import at.mrdevelopment.toolkit.http.ResponseHandler;
import at.mrdevelopment.toolkit.http.WebserviceException;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class AccessPointDefaultRequestStrategy
implements AccessPointRequestStrategy {
    @Override
    public boolean isTaskSupported(UpdateTask updateTask) {
        if (updateTask instanceof PingUpdateTask) {
            return false;
        }
        return !(updateTask instanceof RebootUpdateTask);
    }

    @Override
    public String getQueryAssignedLabelsUrl(int seconds) {
        return "/service/labels/assigned.xml";
    }

    @Override
    public String getQueryDiscoveredLabelsUrl(int seconds) {
        return "/service/labels/discovered.xml";
    }

    @Override
    public String getQueryUpdateTasksUrl() {
        return "/service/tasks/all.xml";
    }

    @Override
    public void abortTasks(HttpServiceClient httpServiceClient, Collection<UUID> tasks) throws WebserviceException {
        for (UUID taskId : tasks) {
            HttpGet request = new HttpGet(String.format("/service/tasks/abort/%s.xml", taskId));
            httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
        }
    }

    @Override
    public void removeTasks(HttpServiceClient httpServiceClient, Collection<UUID> tasks) throws WebserviceException {
        for (UUID taskId : tasks) {
            HttpGet request = new HttpGet(String.format("/service/tasks/remove/%s.xml", taskId));
            httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
        }
    }

    @Override
    public Collection<LabelEvent> queryLabelEvents(HttpServiceClient httpServiceClient) {
        return Collections.emptyList();
    }
}

