<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- List of Wakeup Statistics -->
<xsl:template match="wakeup-statistics">
	<h1>Labels (<xsl:value-of select="count(wakeup-statistic)"/>)</h1>

	<table class="list">
		<tr>
			<th>Label ID</th>
			<th>Count</th>
			<th>Version</th>
			<th>Last seen</th>
			<th>Sync</th>
			<th>Page</th>
			<th>Error</th>
			<th>RSSI</th>
			<th>LQI</th>
			<th>Connection</th>
		</tr>

		<xsl:for-each select="wakeup-statistic">
			<xsl:sort select="./@address"/>
			
			<tr>
				<td class="serial">
					<a>
						<xsl:attribute name="href"><xsl:value-of select="./@address"/>.xml</xsl:attribute>
						<xsl:value-of select="./@address"/>
					</a>
				</td>
				<td><xsl:value-of select="./@count"/></td>
				<td><xsl:value-of select="./@firmware"/></td>
				<td><xsl:value-of select="./@time"/></td>
				<td><xsl:value-of select="./@sync"/></td>
				<td><xsl:value-of select="./@page"/></td>
				<td>
					<xsl:if test="./@error-code != '0'"><xsl:attribute name="class">ERROR</xsl:attribute></xsl:if>
					<xsl:value-of select="./@error-code"/>
				</td>
				<td>
					<xsl:if test="./@rssi!=''">
						<xsl:value-of select="./@rssi"/> dBm
					</xsl:if>
				</td>
				<td><xsl:value-of select="./@lqi"/></td>
				<td>
					<xsl:attribute name="class"><xsl:value-of select="./@connection"/></xsl:attribute>
					<xsl:value-of select="./@connection"/>
				</td>
			</tr>
		</xsl:for-each>
	</table>
</xsl:template>


<!-- Single Wakeup Statistic (details view) -->
<xsl:template match="wakeup-statistic">
	<h2>Ping Statistics of Label <xsl:value-of select="./@address"/></h2>

	<table class="detail">
		<tr>
			<th>Label ID:</th>
			<td class="serial"><xsl:value-of select="./@address"/></td>
		</tr>
		<tr>
			<th>Ping reply count:</th>
			<td><xsl:value-of select="./@count"/></td>
		</tr>
		<tr>
			<th>Connection status:</th>
			<td>
				<xsl:attribute name="class"><xsl:value-of select="./@connection"/></xsl:attribute>
				<xsl:value-of select="./@connection"/>
			</td>
		</tr>
		
		<xsl:if test="number(./@count) &gt; 0">
			<tr>
				<th>Firmware:</th>
				<td>Version <xsl:value-of select="./@firmware"/></td>
			</tr>
			<tr>
				<th>Last seen:</th>
				<td><xsl:value-of select="./@time"/></td>
			</tr>
			<tr>
				<th>Sync quality:</th>
				<td>
					<xsl:if test="./@sync!=''">
						<xsl:value-of select="./@sync"/> (<xsl:value-of select="./@sync-quality"/>)
					</xsl:if>
				</td>
			</tr>
			<tr>
				<th>Current page:</th>
				<td><xsl:value-of select="./@page"/></td>
			</tr>
			<tr>
				<th>Error code:</th>
				<td>
					<xsl:if test="./@error-code != '0'"><xsl:attribute name="class">ERROR</xsl:attribute></xsl:if>
					<xsl:value-of select="./@error-code"/>
				</td>
			</tr>
			<tr>
				<th>RSSI:</th>
				<td>
					<xsl:if test="./@rssi!=''">
						<xsl:value-of select="./@rssi"/> dBm
					</xsl:if>
				</td>
			</tr>
			<tr>
				<th>Link quality:</th>
				<td><xsl:value-of select="./@lqi"/></td>
			</tr>
			<tr>
				<th>Security status:</th>
				<td>
					<xsl:choose>
						<xsl:when test="starts-with(./@firmware, '3')">
							<xsl:choose>
								<xsl:when test="./@key-unset = 'false'">
									<xsl:attribute name="class">VALID</xsl:attribute>
									Encrypted data transmission (AES128)
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">WARNING</xsl:attribute>
									Network key unset
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">UNSUPPORTED</xsl:attribute>
							Encryption not supported
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</xsl:if>
	</table>
	
</xsl:template>

</xsl:stylesheet>
