<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- List of Utilizations -->
<xsl:template match="utilizations">
	<h1>Utilization</h1>

	<table>
		<tr>
			<th>Category</th>
			<th>Current Utilization</th>
			<th>Average Utilization</th>
		</tr>
		<xsl:apply-templates/>
	</table>
</xsl:template>


<!-- Single Utilization -->
<xsl:template match="utilization">
	<xsl:variable name="currentPercentage"><xsl:value-of select="number(./@current)"/></xsl:variable>
	<xsl:variable name="averagePercentage"><xsl:value-of select="number(./@average)"/></xsl:variable>
	<xsl:variable name="currentColor">
		<xsl:choose>
			<xsl:when test="$currentPercentage &lt; 75">green</xsl:when>
			<xsl:otherwise>red</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="averageColor">
		<xsl:choose>
			<xsl:when test="$averagePercentage &lt; 75">green</xsl:when>
			<xsl:otherwise>red</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<tr>
		<td style="width: 16em;"><xsl:value-of select="./@name"/></td>
		<td>
			<div style="position: relative; width: 16em; height: 2em; background-color: #999;">
				<div>
					<xsl:attribute name="style">height: 100%; background-color: <xsl:value-of select="$currentColor"/>; width: <xsl:value-of select="$currentPercentage"/>%;</xsl:attribute>
				</div>
				<div style="position: absolute; top: 4px; left: 0; width: 100%; height: 100%; color: white; font-weight: bold; text-align: center; align:center; vertical-align: middle;">
					<xsl:value-of select="$currentPercentage"/> %
				</div>
				
			</div>
		</td>
		<td>
			<div style="position: relative; width: 16em; height: 2em; background-color: #999;">
				<div>
					<xsl:attribute name="style">height: 100%; background-color: <xsl:value-of select="$averageColor"/>; width: <xsl:value-of select="$averagePercentage"/>%;</xsl:attribute>
				</div>
				<div style="position: absolute; top: 4px; left: 0; width: 100%; height: 100%; color: white; font-weight: bold; text-align: center; vertical-align: middle;">
					<xsl:value-of select="$averagePercentage"/> %
				</div>
			</div>
		</td>
	</tr>
	
</xsl:template>

</xsl:stylesheet>
