<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- List of Update Tasks -->
<xsl:template match="update-tasks">
	<h1>Update Tasks (<xsl:value-of select="count(update-task)"/>)</h1>

	<table class="list">
		<tr>
			<th>ID</th>
			<th>Label ID</th>
			<th>Status</th>
			<th>Updated at</th>
		</tr>

		<xsl:for-each select="update-task">
			<tr>
				<td class="taskId">
					<a>
						<xsl:attribute name="href"><xsl:value-of select="./@id"/>.xml</xsl:attribute>
						<xsl:value-of select="./@id"/>
					</a>
				</td>
				<td class="serial">
					<a>
						<xsl:attribute name="href">../labels/<xsl:value-of select="./@address"/>.xml</xsl:attribute>
						<xsl:value-of select="./@address"/>
					</a>
				</td>
				<td>
					<xsl:attribute name="class"><xsl:value-of select="./@status"/></xsl:attribute>
					<xsl:value-of select="./@status"/>
				</td>
				<td><xsl:value-of select="./@updated-at"/></td>
			</tr>
		</xsl:for-each>

	</table>
</xsl:template>


<!-- Single Update Task (details view) -->
<xsl:template match="update-task">
	<h1>Update task <xsl:value-of select="./@id"/></h1>

	<table class="detail">
		<tr>
			<th>Task ID:</th>
			<td class="taskId"><xsl:value-of select="./@id"/></td>
		</tr>
		<tr>
			<th>Label ID:</th>
			<td class="serial">
				<a>
					<xsl:attribute name="href">../labels/<xsl:value-of select="./@address"/>.xml</xsl:attribute>
					<xsl:value-of select="./@address"/>
				</a>
			</td>
		</tr>
		<tr>
			<th>Status:</th>
			<td>
				<xsl:attribute name="class"><xsl:value-of select="./@status"/></xsl:attribute>
				<xsl:value-of select="./@status"/>
			</td>
		</tr>
		<xsl:if test="./@error-code != ''">
			<tr>
				<th>Error code:</th>
				<td><xsl:value-of select="./@error-code"/></td>
			</tr>
		</xsl:if>
		<tr>
			<th>Priority:</th>
			<td><xsl:value-of select="./@priority"/></td>
		</tr>
		<tr>
			<th>Revision:</th>
			<td><xsl:value-of select="./@revision"/></td>
		</tr>
		<tr>
			<th>Created at:</th>
			<td><xsl:value-of select="./@created-at"/></td>
		</tr>
		<tr>
			<th>Updated at:</th>
			<td><xsl:value-of select="./@updated-at"/></td>
		</tr>
		
		<xsl:apply-templates/>
	</table>

	<h3>Actions</h3>
	<ul>
		<li>
			<a>
				<xsl:attribute name="href">remove/<xsl:value-of select="./@id"/>.xml</xsl:attribute>
				Remove task
			</a>
		</li>
		<li>
			<a>
				<xsl:attribute name="href">abort/<xsl:value-of select="./@id"/>.xml</xsl:attribute>
				Abort task
			</a>
		</li>
	</ul>
</xsl:template>


<!-- ImageUpdateTask (details view) -->
<xsl:template match="image">
	<tr>
		<th>Type:</th>
		<td>Image</td>
	</tr>
	<tr>
		<th>Page:</th>
		<td><xsl:value-of select="./@page"/></td>
	</tr>
	<tr>
		<th>Preload:</th>
		<td><xsl:value-of select="./@preload"/></td>
	</tr>
</xsl:template>


<!-- FirmwareUpdateTask (details view) -->
<xsl:template match="firmware">
	<tr>
		<th>Type:</th>
		<td>Firmware</td>
	</tr>
</xsl:template>


<!-- RefreshDisplayUpdateTask (details view) -->
<xsl:template match="refresh-display">
	<tr>
		<th>Type:</th>
		<td>Refresh display</td>
	</tr>
</xsl:template>


<!-- SwitchPageUpdateTask (details view) -->
<xsl:template match="switch-page">
	<tr>
		<th>Type:</th>
		<td>Switch page</td>
	</tr>
	<tr>
		<th>Page:</th>
		<td><xsl:value-of select="./@page"/></td>
	</tr>
</xsl:template>


<!-- QuerySensorUpdateTask (details view) -->
<xsl:template match="query-sensor">
	<tr>
		<th>Type:</th>
		<td>Query sensors</td>
	</tr>
	<xsl:for-each select="sensor">
		<tr>
			<th>Sensor:</th>
			<td><xsl:value-of select="./@name"/></td>
		</tr>
		<tr>
			<th>RAW value:</th>
			<td><xsl:value-of select="./@value"/></td>
		</tr>
	</xsl:for-each>
</xsl:template>


<!-- ResetAllCountersUpdateTask (details view) -->
<xsl:template match="reset-all-counters">
	<tr>
		<th>Type:</th>
		<td>Reset all counters</td>
	</tr>
</xsl:template>


<!-- ResetCounterUpdateTask (details view) -->
<xsl:template match="reset-counter">
	<tr>
		<th>Type:</th>
		<td>Reset counters</td>
	</tr>
	<xsl:for-each select="counter">
		<tr>
			<th>Counter:</th>
			<td><xsl:value-of select="./@name"/></td>
		</tr>
	</xsl:for-each>
</xsl:template>


<!-- QueryCounterUpdateTask (details view) -->
<xsl:template match="query-counter">
	<tr>
		<th>Type:</th>
		<td>Query counters</td>
	</tr>
	<xsl:for-each select="counter">
		<tr>
			<th>Counter:</th>
			<td><xsl:value-of select="./@name"/></td>
		</tr>
		<tr>
			<th>Value:</th>
			<td><xsl:value-of select="./@value"/></td>
		</tr>
	</xsl:for-each>
</xsl:template>


<!-- Transmission statistics -->
<xsl:template match="transmission-statistic">
	<tr>
		<th>RSSI:</th>
		<td><xsl:value-of select="./@rssi"/> dB</td>
	</tr>
	<tr>
		<th>LQI:</th>
		<td><xsl:value-of select="./@lqi"/></td>
	</tr>
	<tr>
		<th>Transmission time:</th>
		<td><xsl:value-of select="./@transmission-time"/> ms</td>
	</tr>
</xsl:template>

</xsl:stylesheet>
